/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event;

import com.optimizely.ab.NamedThreadFactory;
import com.optimizely.ab.OptimizelyHttpClient;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.internal.PropertyUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventHandler
implements EventHandler,
AutoCloseable {
    public static final String CONFIG_QUEUE_CAPACITY = "async.event.handler.queue.capacity";
    public static final String CONFIG_NUM_WORKERS = "async.event.handler.num.workers";
    public static final String CONFIG_MAX_CONNECTIONS = "async.event.handler.max.connections";
    public static final String CONFIG_MAX_PER_ROUTE = "async.event.handler.event.max.per.route";
    public static final String CONFIG_VALIDATE_AFTER_INACTIVITY = "async.event.handler.validate.after";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_NUM_WORKERS = 2;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final int DEFAULT_VALIDATE_AFTER_INACTIVITY = 5000;
    private static final Logger logger = LoggerFactory.getLogger(AsyncEventHandler.class);
    private static final ProjectConfigResponseHandler EVENT_RESPONSE_HANDLER = new ProjectConfigResponseHandler();
    private final OptimizelyHttpClient httpClient;
    private final ExecutorService workerExecutor;
    private final long closeTimeout;
    private final TimeUnit closeTimeoutUnit;

    @Deprecated
    public AsyncEventHandler(int queueCapacity, int numWorkers) {
        this(queueCapacity, numWorkers, 200, 20, 5000);
    }

    @Deprecated
    public AsyncEventHandler(int queueCapacity, int numWorkers, int maxConnections, int connectionsPerRoute, int validateAfter) {
        this(queueCapacity, numWorkers, maxConnections, connectionsPerRoute, validateAfter, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public AsyncEventHandler(int queueCapacity, int numWorkers, int maxConnections, int connectionsPerRoute, int validateAfter, long closeTimeout, TimeUnit closeTimeoutUnit) {
        queueCapacity = this.validateInput("queueCapacity", queueCapacity, 10000);
        numWorkers = this.validateInput("numWorkers", numWorkers, 2);
        maxConnections = this.validateInput("maxConnections", maxConnections, 200);
        connectionsPerRoute = this.validateInput("connectionsPerRoute", connectionsPerRoute, 20);
        validateAfter = this.validateInput("validateAfter", validateAfter, 5000);
        this.httpClient = OptimizelyHttpClient.builder().withMaxTotalConnections(maxConnections).withMaxPerRoute(connectionsPerRoute).withValidateAfterInactivity(validateAfter).build();
        this.workerExecutor = new ThreadPoolExecutor(numWorkers, numWorkers, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory("optimizely-event-dispatcher-thread-%s", true));
        this.closeTimeout = closeTimeout;
        this.closeTimeoutUnit = closeTimeoutUnit;
    }

    @VisibleForTesting
    public AsyncEventHandler(OptimizelyHttpClient httpClient, ExecutorService workerExecutor) {
        this.httpClient = httpClient;
        this.workerExecutor = workerExecutor;
        this.closeTimeout = Long.MAX_VALUE;
        this.closeTimeoutUnit = TimeUnit.MILLISECONDS;
    }

    public void dispatchEvent(LogEvent logEvent) {
        try {
            this.workerExecutor.execute(new EventDispatcher(logEvent));
        }
        catch (RejectedExecutionException e) {
            logger.error("event dispatch rejected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndAwaitTermination(long timeout, TimeUnit unit) {
        logger.info("event handler shutting down. Attempting to dispatch previously submitted events");
        this.workerExecutor.shutdown();
        try {
            if (!this.workerExecutor.awaitTermination(timeout, unit)) {
                int unprocessedCount = this.workerExecutor.shutdownNow().size();
                logger.warn("timed out waiting for previously submitted events to be dispatched. {} events were dropped. Interrupting dispatch worker(s)", (Object)unprocessedCount);
                if (!this.workerExecutor.awaitTermination(timeout, unit)) {
                    logger.error("unable to gracefully shutdown event handler");
                }
            }
        }
        catch (InterruptedException ie) {
            this.workerExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("unable to close event dispatcher http client", (Throwable)e);
            }
        }
        logger.info("event handler shutdown complete");
    }

    @Override
    public void close() {
        this.shutdownAndAwaitTermination(this.closeTimeout, this.closeTimeoutUnit);
    }

    public static Builder builder() {
        return new Builder();
    }

    private int validateInput(String name, int input, int fallback) {
        if (input <= 0) {
            logger.warn("Invalid value for {}: {}. Defaulting to {}", new Object[]{name, input, fallback});
            return fallback;
        }
        return input;
    }

    public static class Builder {
        int queueCapacity = PropertyUtils.getInteger((String)"async.event.handler.queue.capacity", (Integer)10000);
        int numWorkers = PropertyUtils.getInteger((String)"async.event.handler.num.workers", (Integer)2);
        int maxTotalConnections = PropertyUtils.getInteger((String)"async.event.handler.max.connections", (Integer)200);
        int maxPerRoute = PropertyUtils.getInteger((String)"async.event.handler.event.max.per.route", (Integer)20);
        int validateAfterInactivity = PropertyUtils.getInteger((String)"async.event.handler.validate.after", (Integer)5000);
        private long closeTimeout = Long.MAX_VALUE;
        private TimeUnit closeTimeoutUnit = TimeUnit.MILLISECONDS;

        public Builder withQueueCapacity(int queueCapacity) {
            if (queueCapacity <= 0) {
                logger.warn("Queue capacity cannot be <= 0. Keeping default value: {}", (Object)this.queueCapacity);
                return this;
            }
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder withNumWorkers(int numWorkers) {
            if (numWorkers <= 0) {
                logger.warn("Number of workers cannot be <= 0. Keeping default value: {}", (Object)this.numWorkers);
                return this;
            }
            this.numWorkers = numWorkers;
            return this;
        }

        public Builder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder withMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
            return this;
        }

        public Builder withValidateAfterInactivity(int validateAfterInactivity) {
            this.validateAfterInactivity = validateAfterInactivity;
            return this;
        }

        public Builder withCloseTimeout(long closeTimeout, TimeUnit unit) {
            this.closeTimeout = closeTimeout;
            this.closeTimeoutUnit = unit;
            return this;
        }

        public AsyncEventHandler build() {
            return new AsyncEventHandler(this.queueCapacity, this.numWorkers, this.maxTotalConnections, this.maxPerRoute, this.validateAfterInactivity, this.closeTimeout, this.closeTimeoutUnit);
        }
    }

    private static final class ProjectConfigResponseHandler
    implements ResponseHandler<Void> {
        private ProjectConfigResponseHandler() {
        }

        @CheckForNull
        public Void handleResponse(HttpResponse response) throws IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                response.getEntity();
                return null;
            }
            throw new ClientProtocolException("unexpected response from event endpoint, status: " + status);
        }
    }

    private class EventDispatcher
    implements Runnable {
        private final LogEvent logEvent;

        EventDispatcher(LogEvent logEvent) {
            this.logEvent = logEvent;
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching event to URL {} with params {} and payload \"{}\".", new Object[]{this.logEvent.getEndpointUrl(), this.logEvent.getRequestParams(), this.logEvent.getBody()});
            }
            try {
                Object request = this.logEvent.getRequestMethod() == LogEvent.RequestMethod.GET ? this.generateGetRequest(this.logEvent) : this.generatePostRequest(this.logEvent);
                AsyncEventHandler.this.httpClient.execute((HttpUriRequest)request, EVENT_RESPONSE_HANDLER);
            }
            catch (IOException e) {
                logger.error("event dispatch failed", (Throwable)e);
            }
            catch (URISyntaxException e) {
                logger.error("unable to parse generated URI", (Throwable)e);
            }
        }

        private HttpGet generateGetRequest(LogEvent event) throws URISyntaxException {
            URIBuilder builder = new URIBuilder(event.getEndpointUrl());
            for (Map.Entry param : event.getRequestParams().entrySet()) {
                builder.addParameter((String)param.getKey(), (String)param.getValue());
            }
            return new HttpGet(builder.build());
        }

        private HttpPost generatePostRequest(LogEvent event) throws UnsupportedEncodingException {
            HttpPost post = new HttpPost(event.getEndpointUrl());
            post.setEntity((HttpEntity)new StringEntity(event.getBody()));
            post.addHeader("Content-Type", "application/json");
            return post;
        }
    }
}

