/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.optimizely.ab.HttpClientUtils;
import com.optimizely.ab.OptimizelyHttpClient;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.PollingProjectConfigManager;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.internal.PropertyUtils;
import com.optimizely.ab.notification.NotificationCenter;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProjectConfigManager
extends PollingProjectConfigManager {
    public static final String CONFIG_POLLING_DURATION = "http.project.config.manager.polling.duration";
    public static final String CONFIG_POLLING_UNIT = "http.project.config.manager.polling.unit";
    public static final String CONFIG_BLOCKING_DURATION = "http.project.config.manager.blocking.duration";
    public static final String CONFIG_BLOCKING_UNIT = "http.project.config.manager.blocking.unit";
    public static final String CONFIG_SDK_KEY = "http.project.config.manager.sdk.key";
    public static final String CONFIG_DATAFILE_AUTH_TOKEN = "http.project.config.manager.datafile.auth.token";
    public static final long DEFAULT_POLLING_DURATION = 5L;
    public static final TimeUnit DEFAULT_POLLING_UNIT = TimeUnit.MINUTES;
    public static final long DEFAULT_BLOCKING_DURATION = 10L;
    public static final TimeUnit DEFAULT_BLOCKING_UNIT = TimeUnit.SECONDS;
    private static final Logger logger = LoggerFactory.getLogger(HttpProjectConfigManager.class);
    private final OptimizelyHttpClient httpClient;
    private final URI uri;
    private final String datafileAccessToken;
    private String datafileLastModified;

    private HttpProjectConfigManager(long period, TimeUnit timeUnit, OptimizelyHttpClient httpClient, String url, String datafileAccessToken, long blockingTimeoutPeriod, TimeUnit blockingTimeoutUnit, NotificationCenter notificationCenter) {
        super(period, timeUnit, blockingTimeoutPeriod, blockingTimeoutUnit, notificationCenter);
        this.httpClient = httpClient;
        this.uri = URI.create(url);
        this.datafileAccessToken = datafileAccessToken;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getLastModified() {
        return this.datafileLastModified;
    }

    public String getDatafileFromResponse(HttpResponse response) throws NullPointerException, IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new ClientProtocolException("unexpected response from event endpoint, status is null");
        }
        int status = statusLine.getStatusCode();
        if (status == 304) {
            logger.debug("Not updating ProjectConfig as datafile has not updated since " + this.datafileLastModified);
            return null;
        }
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
            if (lastModifiedHeader != null) {
                this.datafileLastModified = lastModifiedHeader.getValue();
            }
            return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        throw new ClientProtocolException("unexpected response when trying to fetch datafile, status: " + status);
    }

    static ProjectConfig parseProjectConfig(String datafile) throws ConfigParseException {
        return new DatafileProjectConfig.Builder().withDatafile(datafile).build();
    }

    protected ProjectConfig poll() {
        HttpGet httpGet = this.createHttpRequest();
        logger.debug("Fetching datafile from: {}", (Object)httpGet.getURI());
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            String datafile = this.getDatafileFromResponse((HttpResponse)response);
            if (datafile == null) {
                return null;
            }
            return HttpProjectConfigManager.parseProjectConfig(datafile);
        }
        catch (ConfigParseException | IOException e) {
            logger.error("Error fetching datafile", e);
            return null;
        }
    }

    @VisibleForTesting
    HttpGet createHttpRequest() {
        HttpGet httpGet = new HttpGet(this.uri);
        if (this.datafileAccessToken != null) {
            httpGet.setHeader("Authorization", "Bearer " + this.datafileAccessToken);
        }
        if (this.datafileLastModified != null) {
            httpGet.setHeader("If-Modified-Since", this.datafileLastModified);
        }
        return httpGet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String datafile;
        private String url;
        private String datafileAccessToken = null;
        private String format = "https://cdn.optimizely.com/datafiles/%s.json";
        private String authFormat = "https://config.optimizely.com/datafiles/auth/%s.json";
        private OptimizelyHttpClient httpClient;
        private NotificationCenter notificationCenter;
        String sdkKey = PropertyUtils.get((String)"http.project.config.manager.sdk.key");
        long period = PropertyUtils.getLong((String)"http.project.config.manager.polling.duration", (Long)5L);
        TimeUnit timeUnit = (TimeUnit)((Object)PropertyUtils.getEnum((String)"http.project.config.manager.polling.unit", TimeUnit.class, (Object)((Object)DEFAULT_POLLING_UNIT)));
        long blockingTimeoutPeriod = PropertyUtils.getLong((String)"http.project.config.manager.blocking.duration", (Long)10L);
        TimeUnit blockingTimeoutUnit = (TimeUnit)((Object)PropertyUtils.getEnum((String)"http.project.config.manager.blocking.unit", TimeUnit.class, (Object)((Object)DEFAULT_BLOCKING_UNIT)));

        public Builder withDatafile(String datafile) {
            this.datafile = datafile;
            return this;
        }

        public Builder withSdkKey(String sdkKey) {
            this.sdkKey = sdkKey;
            return this;
        }

        public Builder withDatafileAccessToken(String token) {
            this.datafileAccessToken = token;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder withOptimizelyHttpClient(OptimizelyHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withBlockingTimeout(Long period, TimeUnit timeUnit) {
            if (timeUnit == null) {
                logger.warn("TimeUnit cannot be null. Keeping default period: {} and time unit: {}", (Object)this.blockingTimeoutPeriod, (Object)this.blockingTimeoutUnit);
                return this;
            }
            if (period == null) {
                logger.warn("Timeout cannot be null. Keeping default period: {} and time unit: {}", (Object)this.blockingTimeoutPeriod, (Object)this.blockingTimeoutUnit);
                return this;
            }
            if (period <= 0L) {
                logger.warn("Timeout cannot be <= 0. Keeping default period: {} and time unit: {}", (Object)this.blockingTimeoutPeriod, (Object)this.blockingTimeoutUnit);
                return this;
            }
            this.blockingTimeoutPeriod = period;
            this.blockingTimeoutUnit = timeUnit;
            return this;
        }

        public Builder withPollingInterval(Long period, TimeUnit timeUnit) {
            if (timeUnit == null) {
                logger.warn("TimeUnit cannot be null. Keeping default period: {} and time unit: {}", (Object)this.period, (Object)this.timeUnit);
                return this;
            }
            if (period == null) {
                logger.warn("Interval cannot be null. Keeping default period: {} and time unit: {}", (Object)this.period, (Object)this.timeUnit);
                return this;
            }
            if (period <= 0L) {
                logger.warn("Interval cannot be <= 0. Keeping default period: {} and time unit: {}", (Object)this.period, (Object)this.timeUnit);
                return this;
            }
            this.period = period;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder withNotificationCenter(NotificationCenter notificationCenter) {
            this.notificationCenter = notificationCenter;
            return this;
        }

        public HttpProjectConfigManager build() {
            return this.build(false);
        }

        public HttpProjectConfigManager build(boolean defer) {
            if (this.period <= 0L) {
                logger.warn("Invalid polling interval {}, {}. Defaulting to {}, {}", new Object[]{this.period, this.timeUnit, 5L, DEFAULT_POLLING_UNIT});
                this.period = 5L;
                this.timeUnit = DEFAULT_POLLING_UNIT;
            }
            if (this.blockingTimeoutPeriod <= 0L) {
                logger.warn("Invalid polling interval {}, {}. Defaulting to {}, {}", new Object[]{this.blockingTimeoutPeriod, this.blockingTimeoutUnit, 10L, DEFAULT_BLOCKING_UNIT});
                this.blockingTimeoutPeriod = 10L;
                this.blockingTimeoutUnit = DEFAULT_BLOCKING_UNIT;
            }
            if (this.httpClient == null) {
                this.httpClient = HttpClientUtils.getDefaultHttpClient();
            }
            if (this.url == null) {
                if (this.sdkKey == null) {
                    throw new NullPointerException("sdkKey cannot be null");
                }
                this.url = this.datafileAccessToken == null ? String.format(this.format, this.sdkKey) : String.format(this.authFormat, this.sdkKey);
            }
            if (this.notificationCenter == null) {
                this.notificationCenter = new NotificationCenter();
            }
            HttpProjectConfigManager httpProjectManager = new HttpProjectConfigManager(this.period, this.timeUnit, this.httpClient, this.url, this.datafileAccessToken, this.blockingTimeoutPeriod, this.blockingTimeoutUnit, this.notificationCenter);
            if (this.datafile != null) {
                try {
                    ProjectConfig projectConfig = HttpProjectConfigManager.parseProjectConfig(this.datafile);
                    httpProjectManager.setConfig(projectConfig);
                }
                catch (ConfigParseException e) {
                    logger.warn("Error parsing fallback datafile.", (Throwable)e);
                }
            }
            httpProjectManager.start();
            if (!defer) {
                httpProjectManager.getConfig();
            }
            return httpProjectManager;
        }
    }
}

