/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import com.optimizely.ab.HttpClientUtils;
import com.optimizely.ab.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class OptimizelyHttpClient
implements Closeable {
    private final CloseableHttpClient httpClient;

    OptimizelyHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @VisibleForTesting
    HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        return this.httpClient.execute(request);
    }

    public static class Builder {
        private int maxTotalConnections = 200;
        private int maxPerRoute = 20;
        private int validateAfterInactivity = 5000;

        private Builder() {
        }

        public Builder withMaxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder withMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
            return this;
        }

        public Builder withValidateAfterInactivity(int validateAfterInactivity) {
            this.validateAfterInactivity = validateAfterInactivity;
            return this;
        }

        public OptimizelyHttpClient build() {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
            poolingHttpClientConnectionManager.setMaxTotal(this.maxTotalConnections);
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
            poolingHttpClientConnectionManager.setValidateAfterInactivity(this.validateAfterInactivity);
            CloseableHttpClient closableHttpClient = HttpClients.custom().setDefaultRequestConfig(HttpClientUtils.DEFAULT_REQUEST_CONFIG).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).disableCookieManagement().useSystemProperties().build();
            return new OptimizelyHttpClient(closableHttpClient);
        }
    }
}

