/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import com.optimizely.ab.Optimizely;
import com.optimizely.ab.config.HttpProjectConfigManager;
import com.optimizely.ab.config.ProjectConfigManager;
import com.optimizely.ab.event.AsyncEventHandler;
import com.optimizely.ab.event.BatchEventProcessor;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.EventProcessor;
import com.optimizely.ab.internal.PropertyUtils;
import com.optimizely.ab.notification.NotificationCenter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptimizelyFactory {
    private static final Logger logger = LoggerFactory.getLogger(OptimizelyFactory.class);

    public static void setMaxEventBatchSize(int batchSize) {
        if (batchSize <= 0) {
            logger.warn("Batch size cannot be <= 0. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"event.processor.batch.size", (String)Integer.toString(batchSize));
    }

    public static void setMaxEventBatchInterval(long batchInterval) {
        if (batchInterval <= 0L) {
            logger.warn("Batch interval cannot be <= 0. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"event.processor.batch.interval", (String)Long.toString(batchInterval));
    }

    public static void setEventQueueParams(int queueCapacity, int numberWorkers) {
        if (queueCapacity <= 0) {
            logger.warn("Queue capacity cannot be <= 0. Reverting to default configuration.");
            return;
        }
        if (numberWorkers <= 0) {
            logger.warn("Number of workers cannot be <= 0. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"async.event.handler.queue.capacity", (String)Integer.toString(queueCapacity));
        PropertyUtils.set((String)"async.event.handler.num.workers", (String)Integer.toString(numberWorkers));
    }

    public static void setBlockingTimeout(long blockingDuration, TimeUnit blockingTimeout) {
        if (blockingTimeout == null) {
            logger.warn("TimeUnit cannot be null. Reverting to default configuration.");
            return;
        }
        if (blockingDuration <= 0L) {
            logger.warn("Timeout cannot be <= 0. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"http.project.config.manager.blocking.duration", (String)Long.toString(blockingDuration));
        PropertyUtils.set((String)"http.project.config.manager.blocking.unit", (String)blockingTimeout.toString());
    }

    public static void setPollingInterval(long pollingDuration, TimeUnit pollingTimeout) {
        if (pollingTimeout == null) {
            logger.warn("TimeUnit cannot be null. Reverting to default configuration.");
            return;
        }
        if (pollingDuration <= 0L) {
            logger.warn("Interval cannot be <= 0. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"http.project.config.manager.polling.duration", (String)Long.toString(pollingDuration));
        PropertyUtils.set((String)"http.project.config.manager.polling.unit", (String)pollingTimeout.toString());
    }

    public static void setSdkKey(String sdkKey) {
        if (sdkKey == null) {
            logger.warn("SDK key cannot be null. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"http.project.config.manager.sdk.key", (String)sdkKey);
    }

    public static void setDatafileAccessToken(String datafileAccessToken) {
        if (datafileAccessToken == null) {
            logger.warn("Datafile Access Token cannot be null. Reverting to default configuration.");
            return;
        }
        PropertyUtils.set((String)"http.project.config.manager.datafile.auth.token", (String)datafileAccessToken);
    }

    public static Optimizely newDefaultInstance() {
        String sdkKey = PropertyUtils.get((String)"http.project.config.manager.sdk.key");
        return OptimizelyFactory.newDefaultInstance(sdkKey);
    }

    public static Optimizely newDefaultInstance(String sdkKey) {
        if (sdkKey == null) {
            logger.error("Must provide an sdkKey, returning non-op Optimizely client");
            return OptimizelyFactory.newDefaultInstance(() -> null);
        }
        return OptimizelyFactory.newDefaultInstance(sdkKey, null);
    }

    public static Optimizely newDefaultInstance(String sdkKey, String fallback) {
        String datafileAccessToken = PropertyUtils.get((String)"http.project.config.manager.datafile.auth.token");
        return OptimizelyFactory.newDefaultInstance(sdkKey, fallback, datafileAccessToken);
    }

    public static Optimizely newDefaultInstance(String sdkKey, String fallback, String datafileAccessToken) {
        NotificationCenter notificationCenter = new NotificationCenter();
        HttpProjectConfigManager.Builder builder = HttpProjectConfigManager.builder().withDatafile(fallback).withNotificationCenter(notificationCenter).withSdkKey(sdkKey);
        if (datafileAccessToken != null) {
            builder.withDatafileAccessToken(datafileAccessToken);
        }
        return OptimizelyFactory.newDefaultInstance((ProjectConfigManager)builder.build(), notificationCenter);
    }

    public static Optimizely newDefaultInstance(ProjectConfigManager configManager) {
        return OptimizelyFactory.newDefaultInstance(configManager, null);
    }

    public static Optimizely newDefaultInstance(ProjectConfigManager configManager, NotificationCenter notificationCenter) {
        AsyncEventHandler eventHandler = AsyncEventHandler.builder().build();
        return OptimizelyFactory.newDefaultInstance(configManager, notificationCenter, eventHandler);
    }

    public static Optimizely newDefaultInstance(ProjectConfigManager configManager, NotificationCenter notificationCenter, EventHandler eventHandler) {
        if (notificationCenter == null) {
            notificationCenter = new NotificationCenter();
        }
        BatchEventProcessor eventProcessor = BatchEventProcessor.builder().withEventHandler(eventHandler).withNotificationCenter(notificationCenter).build();
        return Optimizely.builder().withEventProcessor((EventProcessor)eventProcessor).withConfigManager(configManager).withNotificationCenter(notificationCenter).build();
    }
}

