/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private final String nameFormat;
    private final boolean daemon;
    private final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
    private final AtomicLong threadCount = new AtomicLong(0L);

    public NamedThreadFactory(String nameFormat, boolean daemon) {
        this.nameFormat = nameFormat;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.backingThreadFactory.newThread(r);
        long threadNumber = this.threadCount.incrementAndGet();
        thread.setName(String.format(this.nameFormat, threadNumber));
        thread.setDaemon(this.daemon);
        return thread;
    }
}

