/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.optimizelyjson;

import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.DefaultConfigParser;
import com.optimizely.ab.config.parser.GsonConfigParser;
import com.optimizely.ab.config.parser.JacksonConfigParser;
import com.optimizely.ab.config.parser.JsonParseException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizelyJSON {
    @Nullable
    private String payload;
    @Nullable
    private Map<String, Object> map;
    private ConfigParser parser;
    private static final Logger logger = LoggerFactory.getLogger(OptimizelyJSON.class);

    public OptimizelyJSON(@Nonnull String payload) {
        this(payload, DefaultConfigParser.getInstance());
    }

    public OptimizelyJSON(@Nonnull String payload, ConfigParser parser) {
        this.payload = payload;
        this.parser = parser;
    }

    public OptimizelyJSON(@Nonnull Map<String, Object> map) {
        this(map, DefaultConfigParser.getInstance());
    }

    public OptimizelyJSON(@Nonnull Map<String, Object> map, ConfigParser parser) {
        this.map = map;
        this.parser = parser;
    }

    @Nonnull
    public String toString() {
        if (this.payload == null && this.map != null) {
            try {
                this.payload = this.parser.toJson(this.map);
            }
            catch (JsonParseException e) {
                logger.error("Provided map could not be converted to a string ({})", (Object)e.toString());
            }
        }
        return this.payload != null ? this.payload : "";
    }

    @Nullable
    public Map<String, Object> toMap() {
        if (this.map == null && this.payload != null) {
            try {
                this.map = this.parser.fromJson(this.payload, Map.class);
            }
            catch (Exception e) {
                logger.error("Provided string could not be converted to a dictionary ({})", (Object)e.toString());
            }
        }
        return this.map;
    }

    @Nullable
    public <T> T getValue(@Nullable String jsonKey, Class<T> clazz) throws JsonParseException {
        String key;
        if (!(this.parser instanceof GsonConfigParser) && !(this.parser instanceof JacksonConfigParser)) {
            throw new JsonParseException("A proper JSON parser is not available. Use Gson or Jackson parser for this operation.");
        }
        Map subMap = this.toMap();
        T result = null;
        if (jsonKey == null || jsonKey.isEmpty()) {
            return this.getValueInternal(subMap, clazz);
        }
        String[] keys = jsonKey.split("\\.", -1);
        for (int i = 0; i < keys.length && subMap != null && !(key = keys[i]).isEmpty(); subMap = (Map)subMap.get(key), ++i) {
            if (i == keys.length - 1) {
                result = this.getValueInternal(subMap.get(key), clazz);
                break;
            }
            if (subMap.get(key) instanceof Map) continue;
            logger.error("Value for JSON key ({}) not found.", (Object)jsonKey);
            break;
        }
        if (result == null) {
            logger.error("Value for path could not be assigned to provided schema.");
        }
        return result;
    }

    private <T> T getValueInternal(@Nullable Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        try {
            String payload = this.parser.toJson(object);
            return this.parser.fromJson(payload, clazz);
        }
        catch (Exception e) {
            logger.error("Map to Java Object failed ({})", (Object)e.toString());
            return null;
        }
    }
}

