/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.optimizelyconfig;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfig;
import com.optimizely.ab.optimizelyconfig.OptimizelyExperiment;
import com.optimizely.ab.optimizelyconfig.OptimizelyFeature;
import com.optimizely.ab.optimizelyconfig.OptimizelyVariable;
import com.optimizely.ab.optimizelyconfig.OptimizelyVariation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptimizelyConfigService {
    private ProjectConfig projectConfig;
    private OptimizelyConfig optimizelyConfig;

    public OptimizelyConfigService(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
        Map<String, OptimizelyExperiment> experimentsMap = this.getExperimentsMap();
        this.optimizelyConfig = new OptimizelyConfig(experimentsMap, this.getFeaturesMap(experimentsMap), projectConfig.getRevision(), projectConfig.toDatafile());
    }

    public OptimizelyConfig getConfig() {
        return this.optimizelyConfig;
    }

    @VisibleForTesting
    Map<String, List<FeatureVariable>> generateFeatureKeyToVariablesMap() {
        List<FeatureFlag> featureFlags = this.projectConfig.getFeatureFlags();
        if (featureFlags == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<FeatureVariable>> featureVariableIdMap = new HashMap<String, List<FeatureVariable>>();
        for (FeatureFlag featureFlag : featureFlags) {
            featureVariableIdMap.put(featureFlag.getKey(), featureFlag.getVariables());
        }
        return featureVariableIdMap;
    }

    @VisibleForTesting
    String getExperimentFeatureKey(String experimentId) {
        List<String> featureKeys = this.projectConfig.getExperimentFeatureKeyMapping().get(experimentId);
        return featureKeys != null ? featureKeys.get(0) : null;
    }

    @VisibleForTesting
    Map<String, OptimizelyExperiment> getExperimentsMap() {
        List<Experiment> experiments = this.projectConfig.getExperiments();
        if (experiments == null) {
            return Collections.emptyMap();
        }
        HashMap<String, OptimizelyExperiment> featureExperimentMap = new HashMap<String, OptimizelyExperiment>();
        for (Experiment experiment : experiments) {
            featureExperimentMap.put(experiment.getKey(), new OptimizelyExperiment(experiment.getId(), experiment.getKey(), this.getVariationsMap(experiment.getVariations(), experiment.getId())));
        }
        return featureExperimentMap;
    }

    @VisibleForTesting
    Map<String, OptimizelyVariation> getVariationsMap(List<Variation> variations, String experimentId) {
        if (variations == null) {
            return Collections.emptyMap();
        }
        Boolean isFeatureExperiment = this.getExperimentFeatureKey(experimentId) != null;
        HashMap<String, OptimizelyVariation> variationKeyMap = new HashMap<String, OptimizelyVariation>();
        for (Variation variation : variations) {
            variationKeyMap.put(variation.getKey(), new OptimizelyVariation(variation.getId(), variation.getKey(), isFeatureExperiment != false ? variation.getFeatureEnabled() : null, this.getMergedVariablesMap(variation, experimentId)));
        }
        return variationKeyMap;
    }

    @VisibleForTesting
    Map<String, OptimizelyVariable> getMergedVariablesMap(Variation variation, String experimentId) {
        String featureKey = this.getExperimentFeatureKey(experimentId);
        if (featureKey != null) {
            Map<String, List<FeatureVariable>> featureKeyToVariablesMap = this.generateFeatureKeyToVariablesMap();
            Map<String, OptimizelyVariable> tempVariableIdMap = this.getFeatureVariableUsageInstanceMap(variation.getFeatureVariableUsageInstances());
            List<FeatureVariable> featureVariables = featureKeyToVariablesMap.get(featureKey);
            if (featureVariables == null) {
                return Collections.emptyMap();
            }
            HashMap<String, OptimizelyVariable> featureVariableKeyMap = new HashMap<String, OptimizelyVariable>();
            for (FeatureVariable featureVariable : featureVariables) {
                featureVariableKeyMap.put(featureVariable.getKey(), new OptimizelyVariable(featureVariable.getId(), featureVariable.getKey(), featureVariable.getType(), variation.getFeatureEnabled() != false && tempVariableIdMap.get(featureVariable.getId()) != null ? tempVariableIdMap.get(featureVariable.getId()).getValue() : featureVariable.getDefaultValue()));
            }
            return featureVariableKeyMap;
        }
        return Collections.emptyMap();
    }

    @VisibleForTesting
    Map<String, OptimizelyVariable> getFeatureVariableUsageInstanceMap(List<FeatureVariableUsageInstance> featureVariableUsageInstances) {
        if (featureVariableUsageInstances == null) {
            return Collections.emptyMap();
        }
        HashMap<String, OptimizelyVariable> featureVariableIdMap = new HashMap<String, OptimizelyVariable>();
        for (FeatureVariableUsageInstance featureVariableUsageInstance : featureVariableUsageInstances) {
            featureVariableIdMap.put(featureVariableUsageInstance.getId(), new OptimizelyVariable(featureVariableUsageInstance.getId(), null, null, featureVariableUsageInstance.getValue()));
        }
        return featureVariableIdMap;
    }

    @VisibleForTesting
    Map<String, OptimizelyFeature> getFeaturesMap(Map<String, OptimizelyExperiment> allExperimentsMap) {
        List<FeatureFlag> featureFlags = this.projectConfig.getFeatureFlags();
        if (featureFlags == null) {
            return Collections.emptyMap();
        }
        HashMap<String, OptimizelyFeature> optimizelyFeatureKeyMap = new HashMap<String, OptimizelyFeature>();
        for (FeatureFlag featureFlag : featureFlags) {
            optimizelyFeatureKeyMap.put(featureFlag.getKey(), new OptimizelyFeature(featureFlag.getId(), featureFlag.getKey(), this.getExperimentsMapForFeature(featureFlag.getExperimentIds(), allExperimentsMap), this.getFeatureVariablesMap(featureFlag.getVariables())));
        }
        return optimizelyFeatureKeyMap;
    }

    @VisibleForTesting
    Map<String, OptimizelyExperiment> getExperimentsMapForFeature(List<String> experimentIds, Map<String, OptimizelyExperiment> allExperimentsMap) {
        if (experimentIds == null) {
            return Collections.emptyMap();
        }
        HashMap<String, OptimizelyExperiment> optimizelyExperimentKeyMap = new HashMap<String, OptimizelyExperiment>();
        for (String experimentId : experimentIds) {
            String experimentKey = this.projectConfig.getExperimentIdMapping().get(experimentId).getKey();
            optimizelyExperimentKeyMap.put(experimentKey, allExperimentsMap.get(experimentKey));
        }
        return optimizelyExperimentKeyMap;
    }

    @VisibleForTesting
    Map<String, OptimizelyVariable> getFeatureVariablesMap(List<FeatureVariable> featureVariables) {
        if (featureVariables == null) {
            return Collections.emptyMap();
        }
        HashMap<String, OptimizelyVariable> featureVariableKeyMap = new HashMap<String, OptimizelyVariable>();
        for (FeatureVariable featureVariable : featureVariables) {
            featureVariableKeyMap.put(featureVariable.getKey(), new OptimizelyVariable(featureVariable.getId(), featureVariable.getKey(), featureVariable.getType(), featureVariable.getDefaultValue()));
        }
        return featureVariableKeyMap;
    }
}

