/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.notification;

import com.optimizely.ab.notification.NotificationHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(NotificationManager.class);
    private final Map<Integer, NotificationHandler<T>> handlers = new LinkedHashMap<Integer, NotificationHandler<T>>();
    private final AtomicInteger counter;

    public NotificationManager() {
        this(new AtomicInteger());
    }

    public NotificationManager(AtomicInteger counter) {
        this.counter = counter;
    }

    public int addHandler(NotificationHandler<T> newHandler) {
        for (NotificationHandler<T> handler : this.handlers.values()) {
            if (!handler.equals(newHandler)) continue;
            logger.warn("Notification listener was already added");
            return -1;
        }
        int notificationId = this.counter.incrementAndGet();
        this.handlers.put(notificationId, newHandler);
        return notificationId;
    }

    public void send(T message) {
        for (Map.Entry<Integer, NotificationHandler<T>> handler : this.handlers.entrySet()) {
            try {
                handler.getValue().handle(message);
            }
            catch (Exception e) {
                logger.warn("Catching exception sending notification for class: {}, handler: {}", message.getClass(), (Object)handler.getKey());
            }
        }
    }

    public void clear() {
        this.handlers.clear();
    }

    public boolean remove(int notificationID) {
        NotificationHandler<T> handler = this.handlers.remove(notificationID);
        return handler != null;
    }

    public int size() {
        return this.handlers.size();
    }
}

