/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.notification;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.notification.ActivateNotification;
import com.optimizely.ab.notification.ActivateNotificationListener;
import com.optimizely.ab.notification.ActivateNotificationListenerInterface;
import com.optimizely.ab.notification.DecisionNotification;
import com.optimizely.ab.notification.NotificationHandler;
import com.optimizely.ab.notification.NotificationListener;
import com.optimizely.ab.notification.NotificationManager;
import com.optimizely.ab.notification.TrackNotification;
import com.optimizely.ab.notification.TrackNotificationListener;
import com.optimizely.ab.notification.TrackNotificationListenerInterface;
import com.optimizely.ab.notification.UpdateConfigNotification;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCenter {
    private static final Logger logger = LoggerFactory.getLogger(NotificationCenter.class);
    private final Map<Class, NotificationManager> notifierMap;

    public NotificationCenter() {
        AtomicInteger counter = new AtomicInteger();
        HashMap validManagers = new HashMap();
        validManagers.put(ActivateNotification.class, new NotificationManager(counter));
        validManagers.put(TrackNotification.class, new NotificationManager(counter));
        validManagers.put(DecisionNotification.class, new NotificationManager(counter));
        validManagers.put(UpdateConfigNotification.class, new NotificationManager(counter));
        validManagers.put(LogEvent.class, new NotificationManager(counter));
        this.notifierMap = Collections.unmodifiableMap(validManagers);
    }

    @Nullable
    public <T> NotificationManager<T> getNotificationManager(Class clazz) {
        return this.notifierMap.get(clazz);
    }

    public <T> int addNotificationHandler(Class<T> clazz, NotificationHandler<T> handler) {
        NotificationManager<T> notificationManager = this.getNotificationManager(clazz);
        if (notificationManager == null) {
            logger.warn("{} not supported by the NotificationCenter.", clazz);
            return -1;
        }
        return notificationManager.addHandler(handler);
    }

    @Deprecated
    public int addActivateNotificationListener(ActivateNotificationListenerInterface activateNotificationListener) {
        NotificationManager<ActivateNotification> notificationManager = this.getNotificationManager(ActivateNotification.class);
        if (notificationManager == null) {
            logger.warn("Notification listener was the wrong type. It was not added to the notification center.");
            return -1;
        }
        if (activateNotificationListener instanceof ActivateNotificationListener) {
            return notificationManager.addHandler((ActivateNotificationListener)activateNotificationListener);
        }
        return notificationManager.addHandler(message -> activateNotificationListener.onActivate(message.getExperiment(), message.getUserId(), message.getAttributes(), message.getVariation(), message.getEvent()));
    }

    @Deprecated
    public int addTrackNotificationListener(TrackNotificationListenerInterface trackNotificationListener) {
        NotificationManager<TrackNotification> notificationManager = this.getNotificationManager(TrackNotification.class);
        if (notificationManager == null) {
            logger.warn("Notification listener was the wrong type. It was not added to the notification center.");
            return -1;
        }
        if (trackNotificationListener instanceof TrackNotificationListener) {
            return notificationManager.addHandler((TrackNotificationListener)trackNotificationListener);
        }
        return notificationManager.addHandler(message -> trackNotificationListener.onTrack(message.getEventKey(), message.getUserId(), message.getAttributes(), message.getEventTags(), message.getEvent()));
    }

    @Deprecated
    public int addNotificationListener(NotificationType notificationType, NotificationListener notificationListener) {
        Class clazz = notificationType.getNotificationTypeClass();
        if (clazz == null || !clazz.isInstance(notificationListener)) {
            logger.warn("Notification listener was the wrong type. It was not added to the notification center.");
            return -1;
        }
        switch (notificationType) {
            case Track: {
                return this.addTrackNotificationListener((TrackNotificationListener)notificationListener);
            }
            case Activate: {
                return this.addActivateNotificationListener((ActivateNotificationListener)notificationListener);
            }
        }
        throw new OptimizelyRuntimeException("Unsupported notificationType");
    }

    public boolean removeNotificationListener(int notificationID) {
        for (NotificationManager manager : this.notifierMap.values()) {
            if (!manager.remove(notificationID)) continue;
            logger.info("Notification listener removed {}", (Object)notificationID);
            return true;
        }
        logger.warn("Notification listener with id {} not found", (Object)notificationID);
        return false;
    }

    public void clearAllNotificationListeners() {
        for (NotificationManager manager : this.notifierMap.values()) {
            manager.clear();
        }
    }

    @Deprecated
    public void clearNotificationListeners(NotificationType notificationType) {
        switch (notificationType) {
            case Track: {
                this.clearNotificationListeners(TrackNotification.class);
                break;
            }
            case Activate: {
                this.clearNotificationListeners(ActivateNotification.class);
                break;
            }
            default: {
                throw new OptimizelyRuntimeException("Unsupported notificationType");
            }
        }
    }

    public void clearNotificationListeners(Class clazz) {
        NotificationManager notificationManager = this.getNotificationManager(clazz);
        if (notificationManager == null) {
            throw new OptimizelyRuntimeException("Unsupported notification type.");
        }
        notificationManager.clear();
    }

    public void send(Object notification) {
        NotificationManager<Object> handler = this.getNotificationManager(notification.getClass());
        if (handler == null) {
            throw new OptimizelyRuntimeException("Unsupported notificationType");
        }
        handler.send(notification);
    }

    @Deprecated
    public static enum NotificationType {
        Activate(ActivateNotificationListener.class),
        Track(TrackNotificationListener.class);

        private Class notificationTypeClass;

        private NotificationType(Class notificationClass) {
            this.notificationTypeClass = notificationClass;
        }

        public Class getNotificationTypeClass() {
            return this.notificationTypeClass;
        }
    }

    public static enum DecisionNotificationType {
        AB_TEST("ab-test"),
        FEATURE("feature"),
        FEATURE_TEST("feature-test"),
        FEATURE_VARIABLE("feature-variable"),
        ALL_FEATURE_VARIABLES("all-feature-variables");

        private final String key;

        private DecisionNotificationType(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

