/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.notification;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.bucketing.FeatureDecision;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.notification.FeatureTestSourceInfo;
import com.optimizely.ab.notification.NotificationCenter;
import com.optimizely.ab.notification.RolloutSourceInfo;
import com.optimizely.ab.notification.SourceInfo;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DecisionNotification {
    protected String type;
    protected String userId;
    protected Map<String, ?> attributes;
    protected Map<String, ?> decisionInfo;

    protected DecisionNotification() {
    }

    protected DecisionNotification(@Nonnull String type, @Nonnull String userId, @Nullable Map<String, ?> attributes, @Nonnull Map<String, ?> decisionInfo) {
        this.type = type;
        this.userId = userId;
        if (attributes == null) {
            attributes = new HashMap();
        }
        this.attributes = attributes;
        this.decisionInfo = decisionInfo;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public Map<String, ?> getDecisionInfo() {
        return this.decisionInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DecisionNotification{");
        sb.append("type='").append(this.type).append('\'');
        sb.append(", userId='").append(this.userId).append('\'');
        sb.append(", attributes=").append(this.attributes);
        sb.append(", decisionInfo=").append(this.decisionInfo);
        sb.append('}');
        return sb.toString();
    }

    public static ExperimentDecisionNotificationBuilder newExperimentDecisionNotificationBuilder() {
        return new ExperimentDecisionNotificationBuilder();
    }

    public static FeatureDecisionNotificationBuilder newFeatureDecisionNotificationBuilder() {
        return new FeatureDecisionNotificationBuilder();
    }

    public static FeatureVariableDecisionNotificationBuilder newFeatureVariableDecisionNotificationBuilder() {
        return new FeatureVariableDecisionNotificationBuilder();
    }

    public static class FeatureVariableDecisionNotificationBuilder {
        public static final String FEATURE_KEY = "featureKey";
        public static final String FEATURE_ENABLED = "featureEnabled";
        public static final String SOURCE = "source";
        public static final String SOURCE_INFO = "sourceInfo";
        public static final String VARIABLE_KEY = "variableKey";
        public static final String VARIABLE_TYPE = "variableType";
        public static final String VARIABLE_VALUE = "variableValue";
        public static final String VARIABLE_VALUES = "variableValues";
        private NotificationCenter.DecisionNotificationType notificationType;
        private String featureKey;
        private Boolean featureEnabled;
        private FeatureDecision featureDecision;
        private String variableKey;
        private String variableType;
        private Object variableValue;
        private Object variableValues;
        private String userId;
        private Map<String, ?> attributes;
        private Map<String, Object> decisionInfo;

        protected FeatureVariableDecisionNotificationBuilder() {
        }

        public FeatureVariableDecisionNotificationBuilder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withAttributes(Map<String, ?> attributes) {
            this.attributes = attributes;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withFeatureKey(String featureKey) {
            this.featureKey = featureKey;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withFeatureEnabled(boolean featureEnabled) {
            this.featureEnabled = featureEnabled;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withFeatureDecision(FeatureDecision featureDecision) {
            this.featureDecision = featureDecision;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withVariableKey(String variableKey) {
            this.variableKey = variableKey;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withVariableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withVariableValue(Object variableValue) {
            this.variableValue = variableValue;
            return this;
        }

        public FeatureVariableDecisionNotificationBuilder withVariableValues(Object variableValues) {
            this.variableValues = variableValues;
            return this;
        }

        public DecisionNotification build() {
            if (this.featureKey == null) {
                throw new OptimizelyRuntimeException("featureKey not set");
            }
            if (this.featureEnabled == null) {
                throw new OptimizelyRuntimeException("featureEnabled not set");
            }
            this.decisionInfo = new HashMap<String, Object>();
            this.decisionInfo.put(FEATURE_KEY, this.featureKey);
            this.decisionInfo.put(FEATURE_ENABLED, this.featureEnabled);
            if (this.variableValues != null) {
                this.notificationType = NotificationCenter.DecisionNotificationType.ALL_FEATURE_VARIABLES;
                this.decisionInfo.put(VARIABLE_VALUES, this.variableValues);
            } else {
                this.notificationType = NotificationCenter.DecisionNotificationType.FEATURE_VARIABLE;
                if (this.variableKey == null) {
                    throw new OptimizelyRuntimeException("variableKey not set");
                }
                if (this.variableType == null) {
                    throw new OptimizelyRuntimeException("variableType not set");
                }
                this.decisionInfo.put(VARIABLE_KEY, this.variableKey);
                this.decisionInfo.put(VARIABLE_TYPE, this.variableType.toString());
                this.decisionInfo.put(VARIABLE_VALUE, this.variableValue);
            }
            SourceInfo sourceInfo = new RolloutSourceInfo();
            if (this.featureDecision != null && FeatureDecision.DecisionSource.FEATURE_TEST.equals((Object)this.featureDecision.decisionSource)) {
                sourceInfo = new FeatureTestSourceInfo(this.featureDecision.experiment.getKey(), this.featureDecision.variation.getKey());
                this.decisionInfo.put(SOURCE, this.featureDecision.decisionSource.toString());
            } else {
                this.decisionInfo.put(SOURCE, FeatureDecision.DecisionSource.ROLLOUT.toString());
            }
            this.decisionInfo.put(SOURCE_INFO, sourceInfo.get());
            return new DecisionNotification(this.notificationType.toString(), this.userId, this.attributes, this.decisionInfo);
        }
    }

    public static class FeatureDecisionNotificationBuilder {
        public static final String FEATURE_KEY = "featureKey";
        public static final String FEATURE_ENABLED = "featureEnabled";
        public static final String SOURCE = "source";
        public static final String SOURCE_INFO = "sourceInfo";
        private String featureKey;
        private Boolean featureEnabled;
        private SourceInfo sourceInfo;
        private FeatureDecision.DecisionSource source;
        private String userId;
        private Map<String, ?> attributes;
        private Map<String, Object> decisionInfo;

        public FeatureDecisionNotificationBuilder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public FeatureDecisionNotificationBuilder withAttributes(Map<String, ?> attributes) {
            this.attributes = attributes;
            return this;
        }

        public FeatureDecisionNotificationBuilder withSourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public FeatureDecisionNotificationBuilder withSource(FeatureDecision.DecisionSource source) {
            this.source = source;
            return this;
        }

        public FeatureDecisionNotificationBuilder withFeatureKey(String featureKey) {
            this.featureKey = featureKey;
            return this;
        }

        public FeatureDecisionNotificationBuilder withFeatureEnabled(Boolean featureEnabled) {
            this.featureEnabled = featureEnabled;
            return this;
        }

        public DecisionNotification build() {
            if (this.source == null) {
                throw new OptimizelyRuntimeException("source not set");
            }
            if (this.featureKey == null) {
                throw new OptimizelyRuntimeException("featureKey not set");
            }
            if (this.featureEnabled == null) {
                throw new OptimizelyRuntimeException("featureEnabled not set");
            }
            this.decisionInfo = new HashMap<String, Object>();
            this.decisionInfo.put(FEATURE_KEY, this.featureKey);
            this.decisionInfo.put(FEATURE_ENABLED, this.featureEnabled);
            this.decisionInfo.put(SOURCE, this.source.toString());
            this.decisionInfo.put(SOURCE_INFO, this.sourceInfo.get());
            return new DecisionNotification(NotificationCenter.DecisionNotificationType.FEATURE.toString(), this.userId, this.attributes, this.decisionInfo);
        }
    }

    public static class ExperimentDecisionNotificationBuilder {
        public static final String EXPERIMENT_KEY = "experimentKey";
        public static final String VARIATION_KEY = "variationKey";
        private String type;
        private String experimentKey;
        private Variation variation;
        private String userId;
        private Map<String, ?> attributes;
        private Map<String, Object> decisionInfo;

        public ExperimentDecisionNotificationBuilder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public ExperimentDecisionNotificationBuilder withAttributes(Map<String, ?> attributes) {
            this.attributes = attributes;
            return this;
        }

        public ExperimentDecisionNotificationBuilder withExperimentKey(String experimentKey) {
            this.experimentKey = experimentKey;
            return this;
        }

        public ExperimentDecisionNotificationBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public ExperimentDecisionNotificationBuilder withVariation(Variation variation) {
            this.variation = variation;
            return this;
        }

        public DecisionNotification build() {
            if (this.type == null) {
                throw new OptimizelyRuntimeException("type not set");
            }
            if (this.experimentKey == null) {
                throw new OptimizelyRuntimeException("experimentKey not set");
            }
            this.decisionInfo = new HashMap<String, Object>();
            this.decisionInfo.put(EXPERIMENT_KEY, this.experimentKey);
            this.decisionInfo.put(VARIATION_KEY, this.variation != null ? this.variation.getKey() : null);
            return new DecisionNotification(this.type, this.userId, this.attributes, this.decisionInfo);
        }
    }
}

