/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final String OPTIMIZELY_PROP_FILE = "optimizely.properties";
    private static Properties properties;

    public static void clear(String key) {
        System.clearProperty("optimizely." + key);
    }

    public static void set(String key, String value) {
        System.setProperty("optimizely." + key, value);
    }

    public static String get(String key) {
        return PropertyUtils.get(key, null);
    }

    public static String get(String key, String dafault) {
        String value = System.getProperty("optimizely." + key.toLowerCase());
        if (value != null) {
            logger.debug("Found {}={} in Java System Properties.", (Object)key, (Object)value);
            return value.trim();
        }
        value = System.getenv("OPTIMIZELY_" + key.replace(".", "_").toUpperCase());
        if (value != null) {
            logger.debug("Found {}={} in System Environment Variables.", (Object)key, (Object)value);
            return value.trim();
        }
        String string = value = properties == null ? null : properties.getProperty(key);
        if (value != null) {
            logger.debug("Found {}={} in {}.", new Object[]{key, value, OPTIMIZELY_PROP_FILE});
            return value.trim();
        }
        return dafault;
    }

    public static Long getLong(String key) {
        return PropertyUtils.getLong(key, null);
    }

    public static Long getLong(String key, Long dafault) {
        String value = PropertyUtils.get(key);
        if (value == null) {
            return dafault;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Cannot convert {} to an long.", (Object)value, (Object)e);
            return dafault;
        }
    }

    public static Integer getInteger(String key) {
        return PropertyUtils.getInteger(key, null);
    }

    public static Integer getInteger(String key, Integer dafault) {
        String value = PropertyUtils.get(key);
        if (value == null) {
            return dafault;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.warn("Cannot convert {} to an integer.", (Object)value, (Object)e);
            return dafault;
        }
    }

    public static <T> T getEnum(String key, Class<T> clazz) {
        return PropertyUtils.getEnum(key, clazz, null);
    }

    public static <T> T getEnum(String key, Class<T> clazz, T dafault) {
        String value = PropertyUtils.get(key);
        if (value == null) {
            return dafault;
        }
        try {
            return Enum.valueOf(clazz, value);
        }
        catch (Exception e) {
            logger.warn("Cannot convert {} to an integer.", (Object)value, (Object)e);
            return dafault;
        }
    }

    private static InputStream getInputStream(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        if (file.isFile() && file.canRead()) {
            return new FileInputStream(file);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(filePath);
    }

    static {
        InputStream input = null;
        try {
            input = PropertyUtils.getInputStream(OPTIMIZELY_PROP_FILE);
            if (input != null) {
                properties = new Properties();
                properties.load(input);
            } else {
                logger.debug("Optimizely properties file not found in filesystem or classpath: '{}'.", (Object)OPTIMIZELY_PROP_FILE);
            }
        }
        catch (Exception e) {
            logger.error("Error loading Optimizely properties file '{}': ", (Object)OPTIMIZELY_PROP_FILE, (Object)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.warn("Error closing properties file.", (Throwable)e);
                }
            }
        }
    }
}

