/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.internal;

import com.google.gson.internal.LinkedTreeMap;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.EmptyCondition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.NullCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.internal.InvalidAudienceCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionUtils {
    static Logger logger = LoggerFactory.getLogger(ConditionUtils.class);

    public static <T> Condition parseConditions(Class<T> clazz, Object object) throws InvalidAudienceCondition {
        Map conditionMap;
        if (object instanceof List) {
            List objectList = (List)object;
            return ConditionUtils.parseConditions(clazz, objectList);
        }
        if (object instanceof String) {
            AudienceIdCondition audienceIdCondition = new AudienceIdCondition((String)object);
            if (clazz.isInstance(audienceIdCondition)) {
                return audienceIdCondition;
            }
            throw new InvalidAudienceCondition(String.format("Expected AudienceIdCondition got %s", clazz.getCanonicalName()));
        }
        try {
            if (object instanceof LinkedTreeMap) {
                if (clazz != UserAttribute.class) {
                    throw new InvalidAudienceCondition(String.format("Expected UserAttributes got %s", clazz.getCanonicalName()));
                }
                LinkedTreeMap conditionMap2 = (LinkedTreeMap)object;
                return new UserAttribute((String)conditionMap2.get((Object)"name"), (String)conditionMap2.get((Object)"type"), (String)conditionMap2.get((Object)"match"), conditionMap2.get((Object)"value"));
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.debug("parser: gson library not loaded");
        }
        try {
            if (object instanceof JSONObject) {
                if (clazz != UserAttribute.class) {
                    throw new InvalidAudienceCondition(String.format("Expected UserAttributes got %s", clazz.getCanonicalName()));
                }
                JSONObject conditionMap3 = (JSONObject)object;
                return new UserAttribute((String)conditionMap3.get((Object)"name"), (String)conditionMap3.get((Object)"type"), (String)conditionMap3.get((Object)"match"), conditionMap3.get((Object)"value"));
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.debug("parser: simple json not found");
        }
        try {
            if (object instanceof JSONArray) {
                return ConditionUtils.parseConditions(clazz, (JSONArray)object);
            }
            if (object instanceof org.json.JSONObject) {
                if (clazz != UserAttribute.class) {
                    throw new InvalidAudienceCondition(String.format("Expected UserAttributes got %s", clazz.getCanonicalName()));
                }
                conditionMap = (org.json.JSONObject)object;
                String match = null;
                Object value = null;
                if (conditionMap.has("match")) {
                    match = (String)conditionMap.get("match");
                }
                if (conditionMap.has("value")) {
                    value = conditionMap.get("value");
                }
                return new UserAttribute((String)conditionMap.get("name"), (String)conditionMap.get("type"), match, value);
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.debug("parser: json package not found.");
        }
        if (clazz != UserAttribute.class) {
            throw new InvalidAudienceCondition(String.format("Expected UserAttributes got %s", clazz.getCanonicalName()));
        }
        conditionMap = (Map)object;
        return new UserAttribute((String)conditionMap.get("name"), (String)conditionMap.get("type"), (String)conditionMap.get("match"), conditionMap.get("value"));
    }

    public static <T> Condition parseConditions(Class<T> clazz, List<Object> rawObjectList) throws InvalidAudienceCondition {
        Condition condition;
        if (rawObjectList.size() == 0) {
            return new EmptyCondition();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        int startingParseIndex = 0;
        String operand = ConditionUtils.operand(rawObjectList.get(startingParseIndex));
        if (operand != null) {
            startingParseIndex = 1;
        } else {
            operand = "or";
        }
        for (int i = startingParseIndex; i < rawObjectList.size(); ++i) {
            Object obj = rawObjectList.get(i);
            conditions.add(ConditionUtils.parseConditions(clazz, obj));
        }
        switch (operand) {
            case "and": {
                condition = new AndCondition(conditions);
                break;
            }
            case "or": {
                condition = new OrCondition(conditions);
                break;
            }
            case "not": {
                condition = new NotCondition(conditions.isEmpty() ? new NullCondition() : (Condition)conditions.get(0));
                break;
            }
            default: {
                condition = new OrCondition(conditions);
            }
        }
        return condition;
    }

    public static String operand(Object object) {
        if (object != null && object instanceof String) {
            String operand;
            switch (operand = (String)object) {
                case "or": 
                case "and": 
                case "not": {
                    return operand;
                }
            }
        }
        return null;
    }

    public static <T> Condition parseConditions(Class<T> clazz, JSONArray conditionJson) throws InvalidAudienceCondition {
        Condition condition;
        if (conditionJson.length() == 0) {
            return new EmptyCondition();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        int startingParseIndex = 0;
        String operand = ConditionUtils.operand(conditionJson.get(startingParseIndex));
        if (operand != null) {
            startingParseIndex = 1;
        } else {
            operand = "or";
        }
        for (int i = startingParseIndex; i < conditionJson.length(); ++i) {
            Object obj = conditionJson.get(i);
            conditions.add(ConditionUtils.parseConditions(clazz, obj));
        }
        switch (operand) {
            case "and": {
                condition = new AndCondition(conditions);
                break;
            }
            case "or": {
                condition = new OrCondition(conditions);
                break;
            }
            case "not": {
                condition = new NotCondition(conditions.isEmpty() ? new NullCondition() : (Condition)conditions.get(0));
                break;
            }
            default: {
                condition = new OrCondition(conditions);
            }
        }
        return condition;
    }
}

