/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.serializer;

import com.optimizely.ab.event.internal.payload.Attribute;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.event.internal.payload.Snapshot;
import com.optimizely.ab.event.internal.payload.Visitor;
import com.optimizely.ab.event.internal.serializer.Serializer;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class JsonSimpleSerializer
implements Serializer {
    JsonSimpleSerializer() {
    }

    @Override
    public <T> String serialize(T payload) {
        JSONObject payloadJsonObj = this.serializeEventBatch((EventBatch)payload);
        return payloadJsonObj.toJSONString();
    }

    private JSONObject serializeEventBatch(EventBatch eventBatch) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"account_id", (Object)eventBatch.getAccountId());
        jsonObject.put((Object)"enrich_decisions", (Object)eventBatch.getEnrichDecisions());
        jsonObject.put((Object)"visitors", (Object)this.serializeVisitors(eventBatch.getVisitors()));
        if (eventBatch.getAnonymizeIp() != null) {
            jsonObject.put((Object)"anonymize_ip", (Object)eventBatch.getAnonymizeIp());
        }
        if (eventBatch.getClientName() != null) {
            jsonObject.put((Object)"client_name", (Object)eventBatch.getClientName());
        }
        if (eventBatch.getClientVersion() != null) {
            jsonObject.put((Object)"client_version", (Object)eventBatch.getClientVersion());
        }
        if (eventBatch.getProjectId() != null) {
            jsonObject.put((Object)"project_id", (Object)eventBatch.getProjectId());
        }
        if (eventBatch.getRevision() != null) {
            jsonObject.put((Object)"revision", (Object)eventBatch.getRevision());
        }
        return jsonObject;
    }

    private JSONArray serializeVisitors(List<Visitor> visitors) {
        JSONArray jsonArray = new JSONArray();
        for (Visitor v : visitors) {
            jsonArray.add((Object)this.serializeVisitor(v));
        }
        return jsonArray;
    }

    private JSONObject serializeVisitor(Visitor visitor) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"visitor_id", (Object)visitor.getVisitorId());
        if (visitor.getSessionId() != null) {
            jsonObject.put((Object)"session_id", (Object)visitor.getSessionId());
        }
        if (visitor.getAttributes() != null) {
            jsonObject.put((Object)"attributes", (Object)this.serializeFeatures(visitor.getAttributes()));
        }
        jsonObject.put((Object)"snapshots", (Object)this.serializeSnapshots(visitor.getSnapshots()));
        return jsonObject;
    }

    private JSONArray serializeSnapshots(List<Snapshot> snapshots) {
        JSONArray jsonArray = new JSONArray();
        for (Snapshot snapshot : snapshots) {
            jsonArray.add((Object)this.serializeSnapshot(snapshot));
        }
        return jsonArray;
    }

    private JSONObject serializeSnapshot(Snapshot snapshot) {
        JSONObject jsonObject = new JSONObject();
        if (snapshot.getDecisions() != null) {
            jsonObject.put((Object)"decisions", (Object)this.serializeDecisions(snapshot.getDecisions()));
        }
        jsonObject.put((Object)"events", (Object)this.serializeEvents(snapshot.getEvents()));
        return jsonObject;
    }

    private JSONArray serializeEvents(List<Event> events) {
        JSONArray jsonArray = new JSONArray();
        for (Event event : events) {
            jsonArray.add((Object)this.serializeEvent(event));
        }
        return jsonArray;
    }

    private JSONObject serializeEvent(Event eventV3) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"timestamp", (Object)eventV3.getTimestamp());
        jsonObject.put((Object)"uuid", (Object)eventV3.getUuid());
        jsonObject.put((Object)"key", (Object)eventV3.getKey());
        if (eventV3.getEntityId() != null) {
            jsonObject.put((Object)"entity_id", (Object)eventV3.getEntityId());
        }
        if (eventV3.getQuantity() != null) {
            jsonObject.put((Object)"quantity", (Object)eventV3.getQuantity());
        }
        if (eventV3.getRevenue() != null) {
            jsonObject.put((Object)"revenue", (Object)eventV3.getRevenue());
        }
        if (eventV3.getTags() != null) {
            jsonObject.put((Object)"tags", (Object)this.serializeTags(eventV3.getTags()));
        }
        if (eventV3.getType() != null) {
            jsonObject.put((Object)"type", (Object)eventV3.getType());
        }
        if (eventV3.getValue() != null) {
            jsonObject.put((Object)"value", (Object)eventV3.getValue());
        }
        return jsonObject;
    }

    private JSONArray serializeTags(Map<String, ?> tags) {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, ?> entry : tags.entrySet()) {
            if (entry.getValue() == null) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)entry.getKey(), entry.getValue());
        }
        return jsonArray;
    }

    private JSONObject serializeDecision(Decision decision) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"campaign_id", (Object)decision.getCampaignId());
        if (decision.getExperimentId() != null) {
            jsonObject.put((Object)"experiment_id", (Object)decision.getExperimentId());
        }
        if (decision.getVariationId() != null) {
            jsonObject.put((Object)"variation_id", (Object)decision.getVariationId());
        }
        jsonObject.put((Object)"is_campaign_holdback", (Object)decision.getIsCampaignHoldback());
        return jsonObject;
    }

    private JSONArray serializeFeatures(List<Attribute> features) {
        JSONArray jsonArray = new JSONArray();
        for (Attribute feature : features) {
            jsonArray.add((Object)this.serializeFeature(feature));
        }
        return jsonArray;
    }

    private JSONObject serializeFeature(Attribute feature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)feature.getType());
        jsonObject.put((Object)"value", feature.getValue());
        if (feature.getEntityId() != null) {
            jsonObject.put((Object)"entity_id", (Object)feature.getEntityId());
        }
        if (feature.getKey() != null) {
            jsonObject.put((Object)"key", (Object)feature.getKey());
        }
        return jsonObject;
    }

    private JSONArray serializeDecisions(List<Decision> layerStates) {
        JSONArray jsonArray = new JSONArray();
        for (Decision layerState : layerStates) {
            jsonArray.add((Object)this.serializeDecision(layerState));
        }
        return jsonArray;
    }
}

