/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.serializer;

import com.optimizely.ab.config.parser.MissingJsonParserException;
import com.optimizely.ab.event.internal.serializer.GsonSerializer;
import com.optimizely.ab.event.internal.serializer.JacksonSerializer;
import com.optimizely.ab.event.internal.serializer.JsonSerializer;
import com.optimizely.ab.event.internal.serializer.JsonSimpleSerializer;
import com.optimizely.ab.event.internal.serializer.Serializer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultJsonSerializer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonSerializer.class);

    private DefaultJsonSerializer() {
    }

    public static Serializer getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Nonnull
    private static Serializer create() {
        Serializer serializer;
        if (DefaultJsonSerializer.isPresent("com.fasterxml.jackson.databind.ObjectMapper")) {
            serializer = new JacksonSerializer();
        } else if (DefaultJsonSerializer.isPresent("com.google.gson.Gson")) {
            serializer = new GsonSerializer();
        } else if (DefaultJsonSerializer.isPresent("org.json.simple.JSONObject")) {
            serializer = new JsonSimpleSerializer();
        } else if (DefaultJsonSerializer.isPresent("org.json.JSONObject")) {
            serializer = new JsonSerializer();
        } else {
            throw new MissingJsonParserException("unable to locate a JSON parser. Please see <link> for more information");
        }
        logger.debug("using json serializer: {}", (Object)serializer.getClass().getSimpleName());
        return serializer;
    }

    private static boolean isPresent(@Nonnull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static /* synthetic */ Serializer access$100() {
        return DefaultJsonSerializer.create();
    }

    private static class LazyHolder {
        private static final Serializer INSTANCE = DefaultJsonSerializer.access$100();

        private LazyHolder() {
        }
    }
}

