/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.event.internal.payload.Attribute;
import com.optimizely.ab.event.internal.payload.Snapshot;
import java.util.List;

public class Visitor {
    @JsonProperty(value="visitor_id")
    String visitorId;
    @JsonProperty(value="session_id")
    String sessionId;
    List<Attribute> attributes;
    List<Snapshot> snapshots;

    @VisibleForTesting
    public Visitor() {
    }

    private Visitor(String visitorId, String sessionId, List<Attribute> attributes, List<Snapshot> snapshots) {
        this.visitorId = visitorId;
        this.sessionId = sessionId;
        this.attributes = attributes;
        this.snapshots = snapshots;
    }

    public String getVisitorId() {
        return this.visitorId;
    }

    public void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public List<Snapshot> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(List<Snapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Visitor visitor = (Visitor)o;
        if (!this.visitorId.equals(visitor.visitorId)) {
            return false;
        }
        if (this.sessionId != null ? !this.sessionId.equals(visitor.sessionId) : visitor.sessionId != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(visitor.attributes) : visitor.attributes != null) {
            return false;
        }
        return this.snapshots.equals(visitor.snapshots);
    }

    public int hashCode() {
        int result = this.visitorId.hashCode();
        result = 31 * result + (this.sessionId != null ? this.sessionId.hashCode() : 0);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + this.snapshots.hashCode();
        return result;
    }

    public static class Builder {
        private String visitorId;
        private String sessionId = null;
        private List<Attribute> attributes;
        private List<Snapshot> snapshots;

        public Builder setVisitorId(String visitorId) {
            this.visitorId = visitorId;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setSnapshots(List<Snapshot> snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Visitor build() {
            return new Visitor(this.visitorId, this.sessionId, this.attributes, this.snapshots);
        }
    }
}

