/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import java.util.List;

public class Snapshot {
    List<Decision> decisions;
    List<Event> events;
    @JsonProperty(value="activation_timestamp")
    Long activationTimestamp;

    @VisibleForTesting
    public Snapshot() {
    }

    public Snapshot(List<Decision> decisions, List<Event> events) {
        this.decisions = decisions;
        this.events = events;
        this.activationTimestamp = null;
    }

    public Long getActivationTimestamp() {
        return this.activationTimestamp;
    }

    public void setActivationTimestamp(Long activationTimestamp) {
        this.activationTimestamp = activationTimestamp;
    }

    public List<Decision> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(List<Decision> decisions) {
        this.decisions = decisions;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot snapshot = (Snapshot)o;
        if (this.activationTimestamp != null ? !this.activationTimestamp.equals(snapshot.activationTimestamp) : snapshot.activationTimestamp != null) {
            return false;
        }
        if (this.decisions != null ? !this.decisions.equals(snapshot.decisions) : snapshot.decisions != null) {
            return false;
        }
        return this.events.equals(snapshot.events);
    }

    public int hashCode() {
        int result = this.decisions.hashCode();
        result = 31 * result + this.events.hashCode();
        if (this.activationTimestamp != null) {
            result = 31 * result + (int)(this.activationTimestamp ^ this.activationTimestamp >>> 32);
        }
        return result;
    }

    public static class Builder {
        private List<Decision> decisions;
        private List<Event> events;

        public Builder setDecisions(List<Decision> decisions) {
            this.decisions = decisions;
            return this;
        }

        public Builder setEvents(List<Event> events) {
            this.events = events;
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this.decisions, this.events);
        }
    }
}

