/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.payload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.payload.Visitor;
import java.util.List;

public class EventBatch {
    @JsonProperty(value="account_id")
    String accountId;
    List<Visitor> visitors;
    @JsonProperty(value="enrich_decisions")
    Boolean enrichDecisions;
    @JsonProperty(value="anonymize_ip")
    Boolean anonymizeIp;
    @JsonProperty(value="client_name")
    String clientName;
    @JsonProperty(value="client_version")
    String clientVersion;
    @JsonProperty(value="project_id")
    String projectId;
    String revision;

    @VisibleForTesting
    public EventBatch() {
    }

    private EventBatch(String clientName, String clientVersion, String accountId, List<Visitor> visitors, Boolean anonymizeIp, String projectId, String revision) {
        this.accountId = accountId;
        this.visitors = visitors;
        this.enrichDecisions = true;
        this.anonymizeIp = anonymizeIp;
        this.clientName = clientName;
        this.clientVersion = clientVersion;
        this.projectId = projectId;
        this.revision = revision;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public List<Visitor> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(List<Visitor> visitors) {
        this.visitors = visitors;
    }

    public Boolean getEnrichDecisions() {
        return this.enrichDecisions;
    }

    public void setEnrichDecisions(Boolean enrichDecisions) {
        this.enrichDecisions = enrichDecisions;
    }

    public Boolean getAnonymizeIp() {
        return this.anonymizeIp;
    }

    public void setAnonymizeIp(Boolean anonymizeIp) {
        this.anonymizeIp = anonymizeIp;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBatch that = (EventBatch)o;
        if (!this.accountId.equals(that.accountId)) {
            return false;
        }
        if (!this.visitors.equals(that.visitors)) {
            return false;
        }
        if (this.anonymizeIp != null ? !this.anonymizeIp.equals(that.anonymizeIp) : that.anonymizeIp != null) {
            return false;
        }
        if (this.clientName != null ? !this.clientName.equals(that.clientName) : that.clientName != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(that.clientVersion) : that.clientVersion != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
            return false;
        }
        return this.revision != null ? this.revision.equals(that.revision) : that.revision == null;
    }

    public int hashCode() {
        int result = this.accountId.hashCode();
        result = 31 * result + this.visitors.hashCode();
        result = 31 * result + (this.anonymizeIp != null ? this.anonymizeIp.hashCode() : 0);
        result = 31 * result + (this.clientName != null ? this.clientName.hashCode() : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String clientName = ClientEngine.JAVA_SDK.getClientEngineValue();
        private String clientVersion = BuildVersionInfo.VERSION;
        private String accountId;
        private List<Visitor> visitors;
        private Boolean anonymizeIp;
        private String projectId;
        private String revision;

        public Builder setClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public Builder setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder setVisitors(List<Visitor> visitors) {
            this.visitors = visitors;
            return this;
        }

        public Builder setAnonymizeIp(Boolean anonymizeIp) {
            this.anonymizeIp = anonymizeIp;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public EventBatch build() {
            return new EventBatch(this.clientName, this.clientVersion, this.accountId, this.visitors, this.anonymizeIp, this.projectId, this.revision);
        }
    }

    public static enum ClientEngine {
        JAVA_SDK("java-sdk"),
        ANDROID_SDK("android-sdk"),
        ANDROID_TV_SDK("android-tv-sdk");

        private final String clientEngineValue;

        private ClientEngine(String clientEngineValue) {
            this.clientEngineValue = clientEngineValue;
        }

        @JsonValue
        public String getClientEngineValue() {
            return this.clientEngineValue;
        }
    }
}

