/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.event.internal.ConversionEvent;
import com.optimizely.ab.event.internal.ImpressionEvent;
import com.optimizely.ab.event.internal.UserContext;
import com.optimizely.ab.internal.EventTagUtils;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserEventFactory {
    private static final Logger logger = LoggerFactory.getLogger(UserEventFactory.class);

    public static ImpressionEvent createImpressionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment activatedExperiment, @Nonnull Variation variation, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        UserContext userContext = new UserContext.Builder().withUserId(userId).withAttributes(attributes).withProjectConfig(projectConfig).build();
        return new ImpressionEvent.Builder().withUserContext(userContext).withLayerId(activatedExperiment.getLayerId()).withExperimentId(activatedExperiment.getId()).withExperimentKey(activatedExperiment.getKey()).withVariationId(variation.getId()).withVariationKey(variation.getKey()).build();
    }

    public static ConversionEvent createConversionEvent(@Nonnull ProjectConfig projectConfig, @Nonnull String userId, @Nonnull String eventId, @Nonnull String eventName, @Nonnull Map<String, ?> attributes, @Nonnull Map<String, ?> eventTags) {
        UserContext userContext = new UserContext.Builder().withUserId(userId).withAttributes(attributes).withProjectConfig(projectConfig).build();
        return new ConversionEvent.Builder().withUserContext(userContext).withEventId(eventId).withEventKey(eventName).withRevenue(EventTagUtils.getRevenueValue(eventTags)).withValue(EventTagUtils.getNumericValue(eventTags)).withTags(eventTags).build();
    }
}

