/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.config.ProjectConfig;
import java.util.Map;
import java.util.StringJoiner;

public class UserContext {
    private final ProjectConfig projectConfig;
    private final String userId;
    private final Map<String, ?> attributes;

    private UserContext(ProjectConfig projectConfig, String userId, Map<String, ?> attributes) {
        this.projectConfig = projectConfig;
        this.userId = userId;
        this.attributes = attributes;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return new StringJoiner(", ", UserContext.class.getSimpleName() + "[", "]").add("projectConfig=" + this.projectConfig.getRevision()).add("userId='" + this.userId + "'").add("attributes=" + this.attributes).toString();
    }

    public static class Builder {
        private ProjectConfig projectConfig;
        private String userId;
        private Map<String, ?> attributes;

        public Builder withProjectConfig(ProjectConfig projectConfig) {
            this.projectConfig = projectConfig;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withAttributes(Map<String, ?> attributes) {
            this.attributes = attributes;
            return this;
        }

        public UserContext build() {
            return new UserContext(this.projectConfig, this.userId, this.attributes);
        }
    }
}

