/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.event.internal.BaseEvent;
import com.optimizely.ab.event.internal.UserContext;
import com.optimizely.ab.event.internal.UserEvent;
import java.util.StringJoiner;

public class ImpressionEvent
extends BaseEvent
implements UserEvent {
    private final UserContext userContext;
    private final String layerId;
    private final String experimentId;
    private final String experimentKey;
    private final String variationKey;
    private final String variationId;

    private ImpressionEvent(UserContext userContext, String layerId, String experimentId, String experimentKey, String variationKey, String variationId) {
        this.userContext = userContext;
        this.layerId = layerId;
        this.experimentId = experimentId;
        this.experimentKey = experimentKey;
        this.variationKey = variationKey;
        this.variationId = variationId;
    }

    @Override
    public UserContext getUserContext() {
        return this.userContext;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public String getExperimentId() {
        return this.experimentId;
    }

    public String getExperimentKey() {
        return this.experimentKey;
    }

    public String getVariationKey() {
        return this.variationKey;
    }

    public String getVariationId() {
        return this.variationId;
    }

    public String toString() {
        return new StringJoiner(", ", ImpressionEvent.class.getSimpleName() + "[", "]").add("userContext=" + this.userContext).add("layerId='" + this.layerId + "'").add("experimentId='" + this.experimentId + "'").add("experimentKey='" + this.experimentKey + "'").add("variationKey='" + this.variationKey + "'").add("variationId='" + this.variationId + "'").toString();
    }

    public static class Builder {
        private UserContext userContext;
        private String layerId;
        private String experimentId;
        private String experimentKey;
        private String variationKey;
        private String variationId;

        public Builder withUserContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public Builder withLayerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public Builder withExperimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public Builder withExperimentKey(String experimentKey) {
            this.experimentKey = experimentKey;
            return this;
        }

        public Builder withVariationKey(String variationKey) {
            this.variationKey = variationKey;
            return this;
        }

        public Builder withVariationId(String variationId) {
            this.variationId = variationId;
            return this;
        }

        public ImpressionEvent build() {
            return new ImpressionEvent(this.userContext, this.layerId, this.experimentId, this.experimentKey, this.variationKey, this.variationId);
        }
    }
}

