/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.BuildVersionInfo;
import com.optimizely.ab.event.internal.ClientEngineInfo;
import com.optimizely.ab.event.internal.ConversionEvent;
import com.optimizely.ab.event.internal.ImpressionEvent;
import com.optimizely.ab.event.internal.UserContext;
import com.optimizely.ab.event.internal.UserEvent;
import com.optimizely.ab.event.internal.payload.Attribute;
import com.optimizely.ab.event.internal.payload.Decision;
import com.optimizely.ab.event.internal.payload.Event;
import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.event.internal.payload.Snapshot;
import com.optimizely.ab.event.internal.payload.Visitor;
import com.optimizely.ab.internal.AttributesUtil;
import com.optimizely.ab.internal.ControlAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventFactory.class);
    public static final String EVENT_ENDPOINT = "https://logx.optimizely.com/v1/events";
    private static final String ACTIVATE_EVENT_KEY = "campaign_activated";

    public static LogEvent createLogEvent(UserEvent userEvent) {
        return EventFactory.createLogEvent(Collections.singletonList(userEvent));
    }

    public static LogEvent createLogEvent(List<UserEvent> userEvents) {
        EventBatch.Builder builder = new EventBatch.Builder();
        ArrayList<Visitor> visitors = new ArrayList<Visitor>(userEvents.size());
        for (UserEvent userEvent : userEvents) {
            if (userEvent == null) continue;
            if (userEvent instanceof ImpressionEvent) {
                visitors.add(EventFactory.createVisitor((ImpressionEvent)userEvent));
            }
            if (userEvent instanceof ConversionEvent) {
                visitors.add(EventFactory.createVisitor((ConversionEvent)userEvent));
            }
            UserContext userContext = userEvent.getUserContext();
            ProjectConfig projectConfig = userContext.getProjectConfig();
            builder.setClientName(ClientEngineInfo.getClientEngine().getClientEngineValue()).setClientVersion(BuildVersionInfo.VERSION).setAccountId(projectConfig.getAccountId()).setAnonymizeIp(projectConfig.getAnonymizeIP()).setProjectId(projectConfig.getProjectId()).setRevision(projectConfig.getRevision());
        }
        if (visitors.isEmpty()) {
            return null;
        }
        builder.setVisitors(visitors);
        return new LogEvent(LogEvent.RequestMethod.POST, EVENT_ENDPOINT, Collections.emptyMap(), builder.build());
    }

    private static Visitor createVisitor(ImpressionEvent impressionEvent) {
        if (impressionEvent == null) {
            return null;
        }
        UserContext userContext = impressionEvent.getUserContext();
        Decision decision = new Decision.Builder().setCampaignId(impressionEvent.getLayerId()).setExperimentId(impressionEvent.getExperimentId()).setVariationId(impressionEvent.getVariationId()).setIsCampaignHoldback(false).build();
        Event event = new Event.Builder().setTimestamp(impressionEvent.getTimestamp()).setUuid(impressionEvent.getUUID()).setEntityId(impressionEvent.getLayerId()).setKey(ACTIVATE_EVENT_KEY).setType(ACTIVATE_EVENT_KEY).build();
        Snapshot snapshot = new Snapshot.Builder().setDecisions(Collections.singletonList(decision)).setEvents(Collections.singletonList(event)).build();
        return new Visitor.Builder().setVisitorId(userContext.getUserId()).setAttributes(EventFactory.buildAttributeList(userContext.getProjectConfig(), userContext.getAttributes())).setSnapshots(Collections.singletonList(snapshot)).build();
    }

    private static Visitor createVisitor(ConversionEvent conversionEvent) {
        if (conversionEvent == null) {
            return null;
        }
        UserContext userContext = conversionEvent.getUserContext();
        Event event = new Event.Builder().setTimestamp(conversionEvent.getTimestamp()).setUuid(conversionEvent.getUUID()).setEntityId(conversionEvent.getEventId()).setKey(conversionEvent.getEventKey()).setRevenue(conversionEvent.getRevenue()).setTags(conversionEvent.getTags()).setType(conversionEvent.getEventKey()).setValue(conversionEvent.getValue()).build();
        Snapshot snapshot = new Snapshot.Builder().setEvents(Collections.singletonList(event)).build();
        return new Visitor.Builder().setVisitorId(userContext.getUserId()).setAttributes(EventFactory.buildAttributeList(userContext.getProjectConfig(), userContext.getAttributes())).setSnapshots(Collections.singletonList(snapshot)).build();
    }

    private static List<Attribute> buildAttributeList(ProjectConfig projectConfig, Map<String, ?> attributes) {
        ArrayList<Attribute> attributesList = new ArrayList<Attribute>();
        if (attributes != null) {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                String attributeId;
                if (entry.getKey().isEmpty() || entry.getValue() == null || !(entry.getValue() instanceof String) && !(entry.getValue() instanceof Boolean) && !AttributesUtil.isValidNumber(entry.getValue()) || (attributeId = projectConfig.getAttributeId(projectConfig, entry.getKey())) == null) continue;
                Attribute attribute = new Attribute.Builder().setEntityId(attributeId).setKey(entry.getKey()).setType("custom").setValue(entry.getValue()).build();
                attributesList.add(attribute);
            }
        }
        if (projectConfig.getBotFiltering() != null) {
            Attribute attribute = new Attribute.Builder().setEntityId(ControlAttribute.BOT_FILTERING_ATTRIBUTE.toString()).setKey(ControlAttribute.BOT_FILTERING_ATTRIBUTE.toString()).setType("custom").setValue(projectConfig.getBotFiltering()).build();
            attributesList.add(attribute);
        }
        return attributesList;
    }
}

