/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal;

import com.optimizely.ab.event.internal.BaseEvent;
import com.optimizely.ab.event.internal.UserContext;
import com.optimizely.ab.event.internal.UserEvent;
import java.util.Map;
import java.util.StringJoiner;

public class ConversionEvent
extends BaseEvent
implements UserEvent {
    private final UserContext userContext;
    private final String eventId;
    private final String eventKey;
    private final Number revenue;
    private final Number value;
    private final Map<String, ?> tags;

    private ConversionEvent(UserContext userContext, String eventId, String eventKey, Number revenue, Number value, Map<String, ?> tags) {
        this.userContext = userContext;
        this.eventId = eventId;
        this.eventKey = eventKey;
        this.revenue = revenue;
        this.value = value;
        this.tags = tags;
    }

    @Override
    public UserContext getUserContext() {
        return this.userContext;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public Number getRevenue() {
        return this.revenue;
    }

    public Number getValue() {
        return this.value;
    }

    public Map<String, ?> getTags() {
        return this.tags;
    }

    public String toString() {
        return new StringJoiner(", ", ConversionEvent.class.getSimpleName() + "[", "]").add("userContext=" + this.userContext).add("eventId='" + this.eventId + "'").add("eventKey='" + this.eventKey + "'").add("revenue=" + this.revenue).add("value=" + this.value).add("tags=" + this.tags).toString();
    }

    public static class Builder {
        private UserContext userContext;
        private String eventId;
        private String eventKey;
        private Number revenue;
        private Number value;
        private Map<String, ?> tags;

        public Builder withUserContext(UserContext userContext) {
            this.userContext = userContext;
            return this;
        }

        public Builder withEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder withEventKey(String eventKey) {
            this.eventKey = eventKey;
            return this;
        }

        public Builder withRevenue(Number revenue) {
            this.revenue = revenue;
            return this;
        }

        public Builder withValue(Number value) {
            this.value = value;
            return this;
        }

        public Builder withTags(Map<String, ?> tags) {
            this.tags = tags;
            return this;
        }

        public ConversionEvent build() {
            return new ConversionEvent(this.userContext, this.eventId, this.eventKey, this.revenue, this.value, this.tags);
        }
    }
}

