/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event;

import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.event.internal.serializer.DefaultJsonSerializer;
import com.optimizely.ab.event.internal.serializer.Serializer;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LogEvent {
    private final RequestMethod requestMethod;
    private final String endpointUrl;
    private final Map<String, String> requestParams;
    private final EventBatch eventBatch;

    public LogEvent(@Nonnull RequestMethod requestMethod, @Nonnull String endpointUrl, @Nonnull Map<String, String> requestParams, EventBatch eventBatch) {
        this.requestMethod = requestMethod;
        this.endpointUrl = endpointUrl;
        this.requestParams = requestParams;
        this.eventBatch = eventBatch;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public Map<String, String> getRequestParams() {
        return this.requestParams;
    }

    public String getBody() {
        if (this.eventBatch == null) {
            return "";
        }
        Serializer serializer = DefaultJsonSerializer.getInstance();
        return serializer.serialize(this.eventBatch);
    }

    public EventBatch getEventBatch() {
        return this.eventBatch;
    }

    public String toString() {
        return "LogEvent{requestMethod=" + (Object)((Object)this.requestMethod) + ", endpointUrl='" + this.endpointUrl + '\'' + ", requestParams=" + this.requestParams + ", body='" + this.getBody() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEvent logEvent = (LogEvent)o;
        return this.requestMethod == logEvent.requestMethod && Objects.equals(this.endpointUrl, logEvent.endpointUrl) && Objects.equals(this.requestParams, logEvent.requestParams) && Objects.equals(this.eventBatch, logEvent.eventBatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestMethod, this.endpointUrl, this.requestParams, this.eventBatch});
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

