/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event;

import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.EventProcessor;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.internal.EventFactory;
import com.optimizely.ab.event.internal.UserEvent;
import com.optimizely.ab.notification.NotificationCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ForwardingEventProcessor.class);
    private final EventHandler eventHandler;
    private final NotificationCenter notificationCenter;

    public ForwardingEventProcessor(EventHandler eventHandler, NotificationCenter notificationCenter) {
        this.eventHandler = eventHandler;
        this.notificationCenter = notificationCenter;
    }

    @Override
    public void process(UserEvent userEvent) {
        LogEvent logEvent = EventFactory.createLogEvent(userEvent);
        if (this.notificationCenter != null) {
            this.notificationCenter.send(logEvent);
        }
        try {
            this.eventHandler.dispatchEvent(logEvent);
        }
        catch (Exception e) {
            logger.error("Error dispatching event: {}", (Object)logEvent, (Object)e);
        }
    }
}

