/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Rollout;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.JsonParseException;
import com.optimizely.ab.internal.ConditionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class JsonSimpleConfigParser
implements ConfigParser {
    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        try {
            JSONParser parser = new JSONParser();
            JSONObject rootObject = (JSONObject)parser.parse(json);
            String accountId = (String)rootObject.get((Object)"accountId");
            String projectId = (String)rootObject.get((Object)"projectId");
            String revision = (String)rootObject.get((Object)"revision");
            String version = (String)rootObject.get((Object)"version");
            int datafileVersion = Integer.parseInt(version);
            List<Experiment> experiments = this.parseExperiments((JSONArray)rootObject.get((Object)"experiments"));
            List<Attribute> attributes = this.parseAttributes((JSONArray)rootObject.get((Object)"attributes"));
            List<EventType> events = this.parseEvents((JSONArray)rootObject.get((Object)"events"));
            List<Audience> audiences = Collections.emptyList();
            if (rootObject.containsKey((Object)"audiences")) {
                audiences = this.parseAudiences((JSONArray)parser.parse(rootObject.get((Object)"audiences").toString()));
            }
            List<Audience> typedAudiences = null;
            if (rootObject.containsKey((Object)"typedAudiences")) {
                typedAudiences = this.parseTypedAudiences((JSONArray)parser.parse(rootObject.get((Object)"typedAudiences").toString()));
            }
            List<Group> groups = this.parseGroups((JSONArray)rootObject.get((Object)"groups"));
            boolean anonymizeIP = false;
            if (datafileVersion >= Integer.parseInt(ProjectConfig.Version.V3.toString())) {
                anonymizeIP = (Boolean)rootObject.get((Object)"anonymizeIP");
            }
            List<FeatureFlag> featureFlags = null;
            List<Rollout> rollouts = null;
            Boolean botFiltering = null;
            if (datafileVersion >= Integer.parseInt(ProjectConfig.Version.V4.toString())) {
                featureFlags = this.parseFeatureFlags((JSONArray)rootObject.get((Object)"featureFlags"));
                rollouts = this.parseRollouts((JSONArray)rootObject.get((Object)"rollouts"));
                if (rootObject.containsKey((Object)"botFiltering")) {
                    botFiltering = (Boolean)rootObject.get((Object)"botFiltering");
                }
            }
            return new DatafileProjectConfig(accountId, anonymizeIP, botFiltering, projectId, revision, version, attributes, audiences, typedAudiences, events, experiments, featureFlags, groups, rollouts);
        }
        catch (RuntimeException ex) {
            throw new ConfigParseException("Unable to parse datafile: " + json, ex);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson) {
        return this.parseExperiments(experimentJson, "");
    }

    private List<Experiment> parseExperiments(JSONArray experimentJson, String groupId) {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>(experimentJson.size());
        for (Object obj : experimentJson) {
            JSONObject experimentObject = (JSONObject)obj;
            String id = (String)experimentObject.get((Object)"id");
            String key = (String)experimentObject.get((Object)"key");
            Object statusJson = experimentObject.get((Object)"status");
            String status = statusJson == null ? Experiment.ExperimentStatus.NOT_STARTED.toString() : (String)experimentObject.get((Object)"status");
            Object layerIdObject = experimentObject.get((Object)"layerId");
            String layerId = layerIdObject == null ? null : (String)layerIdObject;
            JSONArray audienceIdsJson = (JSONArray)experimentObject.get((Object)"audienceIds");
            ArrayList<String> audienceIds = new ArrayList<String>(audienceIdsJson.size());
            for (Object audienceIdObj : audienceIdsJson) {
                audienceIds.add((String)audienceIdObj);
            }
            Condition conditions = null;
            if (experimentObject.containsKey((Object)"audienceConditions")) {
                Object jsonCondition = experimentObject.get((Object)"audienceConditions");
                try {
                    conditions = ConditionUtils.parseConditions(AudienceIdCondition.class, jsonCondition);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.ALL, "problem parsing audience conditions", e);
                }
            }
            List<Variation> variations = this.parseVariations((JSONArray)experimentObject.get((Object)"variations"));
            Map<String, String> userIdToVariationKeyMap = this.parseForcedVariations((JSONObject)experimentObject.get((Object)"forcedVariations"));
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation((JSONArray)experimentObject.get((Object)"trafficAllocation"));
            experiments.add(new Experiment(id, key, status, layerId, audienceIds, conditions, variations, userIdToVariationKeyMap, trafficAllocations, groupId));
        }
        return experiments;
    }

    private List<String> parseExperimentIds(JSONArray experimentIdsJsonArray) {
        ArrayList<String> experimentIds = new ArrayList<String>(experimentIdsJsonArray.size());
        for (Object experimentIdObj : experimentIdsJsonArray) {
            experimentIds.add((String)experimentIdObj);
        }
        return experimentIds;
    }

    private List<FeatureFlag> parseFeatureFlags(JSONArray featureFlagJson) {
        ArrayList<FeatureFlag> featureFlags = new ArrayList<FeatureFlag>(featureFlagJson.size());
        for (Object obj : featureFlagJson) {
            JSONObject featureFlagObject = (JSONObject)obj;
            String id = (String)featureFlagObject.get((Object)"id");
            String key = (String)featureFlagObject.get((Object)"key");
            String layerId = (String)featureFlagObject.get((Object)"rolloutId");
            JSONArray experimentIdsJsonArray = (JSONArray)featureFlagObject.get((Object)"experimentIds");
            List<String> experimentIds = this.parseExperimentIds(experimentIdsJsonArray);
            List<FeatureVariable> featureVariable = this.parseFeatureVariables((JSONArray)featureFlagObject.get((Object)"variables"));
            featureFlags.add(new FeatureFlag(id, key, layerId, experimentIds, featureVariable));
        }
        return featureFlags;
    }

    private List<Variation> parseVariations(JSONArray variationJson) {
        ArrayList<Variation> variations = new ArrayList<Variation>(variationJson.size());
        for (Object obj : variationJson) {
            JSONObject variationObject = (JSONObject)obj;
            String id = (String)variationObject.get((Object)"id");
            String key = (String)variationObject.get((Object)"key");
            Boolean featureEnabled = false;
            if (variationObject.containsKey((Object)"featureEnabled")) {
                featureEnabled = (Boolean)variationObject.get((Object)"featureEnabled");
            }
            List<FeatureVariableUsageInstance> featureVariableUsageInstances = null;
            if (variationObject.containsKey((Object)"variables")) {
                featureVariableUsageInstances = this.parseFeatureVariableInstances((JSONArray)variationObject.get((Object)"variables"));
            }
            variations.add(new Variation(id, key, featureEnabled, featureVariableUsageInstances));
        }
        return variations;
    }

    private Map<String, String> parseForcedVariations(JSONObject forcedVariationJson) {
        HashMap<String, String> userIdToVariationKeyMap = new HashMap<String, String>();
        for (Object obj : forcedVariationJson.entrySet()) {
            Map.Entry entry = (Map.Entry)obj;
            userIdToVariationKeyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return userIdToVariationKeyMap;
    }

    private List<TrafficAllocation> parseTrafficAllocation(JSONArray trafficAllocationJson) {
        ArrayList<TrafficAllocation> trafficAllocation = new ArrayList<TrafficAllocation>(trafficAllocationJson.size());
        for (Object obj : trafficAllocationJson) {
            JSONObject allocationObject = (JSONObject)obj;
            String entityId = (String)allocationObject.get((Object)"entityId");
            long endOfRange = (Long)allocationObject.get((Object)"endOfRange");
            trafficAllocation.add(new TrafficAllocation(entityId, (int)endOfRange));
        }
        return trafficAllocation;
    }

    private List<Attribute> parseAttributes(JSONArray attributeJson) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(attributeJson.size());
        for (Object obj : attributeJson) {
            JSONObject attributeObject = (JSONObject)obj;
            String id = (String)attributeObject.get((Object)"id");
            String key = (String)attributeObject.get((Object)"key");
            String segmentId = (String)attributeObject.get((Object)"segmentId");
            attributes.add(new Attribute(id, key, segmentId));
        }
        return attributes;
    }

    private List<EventType> parseEvents(JSONArray eventJson) {
        ArrayList<EventType> events = new ArrayList<EventType>(eventJson.size());
        for (Object obj : eventJson) {
            JSONObject eventObject = (JSONObject)obj;
            JSONArray experimentIdsJson = (JSONArray)eventObject.get((Object)"experimentIds");
            List<String> experimentIds = this.parseExperimentIds(experimentIdsJson);
            String id = (String)eventObject.get((Object)"id");
            String key = (String)eventObject.get((Object)"key");
            events.add(new EventType(id, key, experimentIds));
        }
        return events;
    }

    private List<Audience> parseAudiences(JSONArray audienceJson) throws ParseException {
        JSONParser parser = new JSONParser();
        ArrayList<Audience> audiences = new ArrayList<Audience>(audienceJson.size());
        for (Object obj : audienceJson) {
            JSONObject audienceObject = (JSONObject)obj;
            String id = (String)audienceObject.get((Object)"id");
            String key = (String)audienceObject.get((Object)"name");
            Object conditionObject = audienceObject.get((Object)"conditions");
            Object conditionJson = parser.parse((String)conditionObject);
            Condition conditions = ConditionUtils.parseConditions(UserAttribute.class, conditionJson);
            audiences.add(new Audience(id, key, conditions));
        }
        return audiences;
    }

    private List<Audience> parseTypedAudiences(JSONArray audienceJson) throws ParseException {
        ArrayList<Audience> audiences = new ArrayList<Audience>(audienceJson.size());
        for (Object obj : audienceJson) {
            JSONObject audienceObject = (JSONObject)obj;
            String id = (String)audienceObject.get((Object)"id");
            String key = (String)audienceObject.get((Object)"name");
            Object conditionObject = audienceObject.get((Object)"conditions");
            Condition conditions = ConditionUtils.parseConditions(UserAttribute.class, conditionObject);
            audiences.add(new Audience(id, key, conditions));
        }
        return audiences;
    }

    private List<Group> parseGroups(JSONArray groupJson) {
        ArrayList<Group> groups = new ArrayList<Group>(groupJson.size());
        for (Object obj : groupJson) {
            JSONObject groupObject = (JSONObject)obj;
            String id = (String)groupObject.get((Object)"id");
            String policy = (String)groupObject.get((Object)"policy");
            List<Experiment> experiments = this.parseExperiments((JSONArray)groupObject.get((Object)"experiments"), id);
            List<TrafficAllocation> trafficAllocations = this.parseTrafficAllocation((JSONArray)groupObject.get((Object)"trafficAllocation"));
            groups.add(new Group(id, policy, experiments, trafficAllocations));
        }
        return groups;
    }

    private List<FeatureVariable> parseFeatureVariables(JSONArray featureVariablesJson) {
        ArrayList<FeatureVariable> featureVariables = new ArrayList<FeatureVariable>(featureVariablesJson.size());
        for (Object obj : featureVariablesJson) {
            JSONObject featureVariableObject = (JSONObject)obj;
            String id = (String)featureVariableObject.get((Object)"id");
            String key = (String)featureVariableObject.get((Object)"key");
            String defaultValue = (String)featureVariableObject.get((Object)"defaultValue");
            String type = (String)featureVariableObject.get((Object)"type");
            String subType = (String)featureVariableObject.get((Object)"subType");
            FeatureVariable.VariableStatus status = FeatureVariable.VariableStatus.fromString((String)featureVariableObject.get((Object)"status"));
            featureVariables.add(new FeatureVariable(id, key, defaultValue, status, type, subType));
        }
        return featureVariables;
    }

    private List<FeatureVariableUsageInstance> parseFeatureVariableInstances(JSONArray featureVariableInstancesJson) {
        ArrayList<FeatureVariableUsageInstance> featureVariableUsageInstances = new ArrayList<FeatureVariableUsageInstance>(featureVariableInstancesJson.size());
        for (Object obj : featureVariableInstancesJson) {
            JSONObject featureVariableInstanceObject = (JSONObject)obj;
            String id = (String)featureVariableInstanceObject.get((Object)"id");
            String value = (String)featureVariableInstanceObject.get((Object)"value");
            featureVariableUsageInstances.add(new FeatureVariableUsageInstance(id, value));
        }
        return featureVariableUsageInstances;
    }

    private List<Rollout> parseRollouts(JSONArray rolloutsJson) {
        ArrayList<Rollout> rollouts = new ArrayList<Rollout>(rolloutsJson.size());
        for (Object obj : rolloutsJson) {
            JSONObject rolloutObject = (JSONObject)obj;
            String id = (String)rolloutObject.get((Object)"id");
            List<Experiment> experiments = this.parseExperiments((JSONArray)rolloutObject.get((Object)"experiments"));
            rollouts.add(new Rollout(id, experiments));
        }
        return rollouts;
    }

    @Override
    public String toJson(Object src) {
        return JSONValue.toJSONString((Object)src);
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) throws JsonParseException {
        if (Map.class.isAssignableFrom(clazz)) {
            try {
                return (T)new JSONParser().parse(json, new ContainerFactory(){

                    public Map createObjectContainer() {
                        return new HashMap();
                    }

                    public List creatArrayContainer() {
                        return new ArrayList();
                    }
                });
            }
            catch (ParseException e) {
                throw new JsonParseException("Unable to parse JSON string: " + e.toString());
            }
        }
        throw new JsonParseException("Parsing fails with a unsupported type");
    }
}

