/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

final class JsonHelpers {
    JsonHelpers() {
    }

    static Object convertToJsonObject(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            JSONObject jObj = new JSONObject();
            for (Map.Entry entry : map.entrySet()) {
                jObj.put(entry.getKey().toString(), JsonHelpers.convertToJsonObject(entry.getValue()));
            }
            return jObj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            JSONArray jArray = new JSONArray();
            for (Object value : list) {
                jArray.put(JsonHelpers.convertToJsonObject(value));
            }
            return jArray;
        }
        return obj;
    }

    static Map<String, Object> jsonObjectToMap(JSONObject jObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jObj.get(key);
            if (value instanceof JSONArray) {
                value = JsonHelpers.jsonArrayToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonHelpers.jsonObjectToMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    static List<Object> jsonArrayToList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : array) {
            if (value instanceof JSONArray) {
                value = JsonHelpers.jsonArrayToList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonHelpers.jsonObjectToMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

