/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.TypedAudience;
import com.optimizely.ab.config.parser.AudienceJacksonDeserializer;
import com.optimizely.ab.config.parser.ConditionJacksonDeserializer;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.DatafileJacksonDeserializer;
import com.optimizely.ab.config.parser.JsonParseException;
import com.optimizely.ab.config.parser.TypedAudienceJacksonDeserializer;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class JacksonConfigParser
implements ConfigParser {
    private ObjectMapper objectMapper;

    public JacksonConfigParser() {
        this(new ObjectMapper());
    }

    JacksonConfigParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.objectMapper.registerModule((Module)new ProjectConfigModule());
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        try {
            return (ProjectConfig)this.objectMapper.readValue(json, DatafileProjectConfig.class);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    @Override
    public String toJson(Object src) throws JsonParseException {
        try {
            return this.objectMapper.writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new JsonParseException("Serialization failed: " + e.toString());
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) throws JsonParseException {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new JsonParseException("Unable to parse JSON string: " + e.toString());
        }
    }

    class ProjectConfigModule
    extends SimpleModule {
        private static final String NAME = "ProjectConfigModule";

        public ProjectConfigModule() {
            super(NAME);
            this.addDeserializer(DatafileProjectConfig.class, new DatafileJacksonDeserializer());
            this.addDeserializer(Audience.class, new AudienceJacksonDeserializer(JacksonConfigParser.this.objectMapper));
            this.addDeserializer(TypedAudience.class, new TypedAudienceJacksonDeserializer(JacksonConfigParser.this.objectMapper));
            this.addDeserializer(Condition.class, new ConditionJacksonDeserializer(JacksonConfigParser.this.objectMapper));
        }
    }
}

