/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.optimizely.ab.bucketing.DecisionService;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.internal.ConditionUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GsonHelpers {
    private static final Logger logger = LoggerFactory.getLogger(DecisionService.class);

    GsonHelpers() {
    }

    private static List<Variation> parseVariations(JsonArray variationJson, JsonDeserializationContext context) {
        ArrayList<Variation> variations = new ArrayList<Variation>(variationJson.size());
        for (Object obj : variationJson) {
            JsonObject variationObject = (JsonObject)obj;
            String id = variationObject.get("id").getAsString();
            String key = variationObject.get("key").getAsString();
            Boolean featureEnabled = false;
            if (variationObject.has("featureEnabled") && !variationObject.get("featureEnabled").isJsonNull()) {
                featureEnabled = variationObject.get("featureEnabled").getAsBoolean();
            }
            List variableUsageInstances = null;
            if (variationObject.has("variables")) {
                Type featureVariableUsageInstancesType = new TypeToken<List<FeatureVariableUsageInstance>>(){}.getType();
                variableUsageInstances = (List)context.deserialize((JsonElement)variationObject.getAsJsonArray("variables"), featureVariableUsageInstancesType);
            }
            variations.add(new Variation(id, key, featureEnabled, variableUsageInstances));
        }
        return variations;
    }

    private static Map<String, String> parseForcedVariations(JsonObject forcedVariationJson) {
        HashMap<String, String> userIdToVariationKeyMap = new HashMap<String, String>();
        Set entrySet = forcedVariationJson.entrySet();
        for (Map.Entry entry : entrySet) {
            userIdToVariationKeyMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return userIdToVariationKeyMap;
    }

    static List<TrafficAllocation> parseTrafficAllocation(JsonArray trafficAllocationJson) {
        ArrayList<TrafficAllocation> trafficAllocation = new ArrayList<TrafficAllocation>(trafficAllocationJson.size());
        for (Object obj : trafficAllocationJson) {
            JsonObject allocationObject = (JsonObject)obj;
            String entityId = allocationObject.get("entityId").getAsString();
            int endOfRange = allocationObject.get("endOfRange").getAsInt();
            trafficAllocation.add(new TrafficAllocation(entityId, endOfRange));
        }
        return trafficAllocation;
    }

    static Condition parseAudienceConditions(JsonObject experimentJson) {
        if (!experimentJson.has("audienceConditions")) {
            return null;
        }
        Gson gson = new Gson();
        JsonElement conditionsElement = experimentJson.get("audienceConditions");
        if (conditionsElement.isJsonArray()) {
            List rawObjectList = (List)gson.fromJson(conditionsElement, List.class);
            return ConditionUtils.parseConditions(AudienceIdCondition.class, rawObjectList);
        }
        Object jsonObject = gson.fromJson(conditionsElement, Object.class);
        return ConditionUtils.parseConditions(AudienceIdCondition.class, jsonObject);
    }

    static Experiment parseExperiment(JsonObject experimentJson, String groupId, JsonDeserializationContext context) {
        String id = experimentJson.get("id").getAsString();
        String key = experimentJson.get("key").getAsString();
        JsonElement experimentStatusJson = experimentJson.get("status");
        String status = experimentStatusJson.isJsonNull() ? Experiment.ExperimentStatus.NOT_STARTED.toString() : experimentStatusJson.getAsString();
        JsonElement layerIdJson = experimentJson.get("layerId");
        String layerId = layerIdJson == null ? null : layerIdJson.getAsString();
        JsonArray audienceIdsJson = experimentJson.getAsJsonArray("audienceIds");
        ArrayList<String> audienceIds = new ArrayList<String>(audienceIdsJson.size());
        for (JsonElement audienceIdObj : audienceIdsJson) {
            audienceIds.add(audienceIdObj.getAsString());
        }
        Condition conditions = GsonHelpers.parseAudienceConditions(experimentJson);
        List<Variation> variations = GsonHelpers.parseVariations(experimentJson.getAsJsonArray("variations"), context);
        Map<String, String> userIdToVariationKeyMap = GsonHelpers.parseForcedVariations(experimentJson.getAsJsonObject("forcedVariations"));
        List<TrafficAllocation> trafficAllocations = GsonHelpers.parseTrafficAllocation(experimentJson.getAsJsonArray("trafficAllocation"));
        return new Experiment(id, key, status, layerId, audienceIds, conditions, variations, userIdToVariationKeyMap, trafficAllocations, groupId);
    }

    static Experiment parseExperiment(JsonObject experimentJson, JsonDeserializationContext context) {
        return GsonHelpers.parseExperiment(experimentJson, "", context);
    }

    static FeatureFlag parseFeatureFlag(JsonObject featureFlagJson, JsonDeserializationContext context) {
        String id = featureFlagJson.get("id").getAsString();
        String key = featureFlagJson.get("key").getAsString();
        String layerId = featureFlagJson.get("rolloutId").getAsString();
        JsonArray experimentIdsJson = featureFlagJson.getAsJsonArray("experimentIds");
        ArrayList<String> experimentIds = new ArrayList<String>();
        for (JsonElement experimentIdObj : experimentIdsJson) {
            experimentIds.add(experimentIdObj.getAsString());
        }
        ArrayList<FeatureVariable> FeatureVariables = new ArrayList();
        try {
            Type FeatureVariableType = new TypeToken<List<FeatureVariable>>(){}.getType();
            FeatureVariables = (List)context.deserialize((JsonElement)featureFlagJson.getAsJsonArray("variables"), FeatureVariableType);
        }
        catch (JsonParseException exception) {
            logger.warn("Unable to parse variables for feature \"" + key + "\". JsonParseException: " + (Object)((Object)exception));
        }
        return new FeatureFlag(id, key, layerId, experimentIds, FeatureVariables);
    }
}

