/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.TypedAudience;
import com.optimizely.ab.config.parser.AudienceGsonDeserializer;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.DatafileGsonDeserializer;
import com.optimizely.ab.config.parser.ExperimentGsonDeserializer;
import com.optimizely.ab.config.parser.FeatureFlagGsonDeserializer;
import com.optimizely.ab.config.parser.GroupGsonDeserializer;
import com.optimizely.ab.config.parser.JsonParseException;
import javax.annotation.Nonnull;

public final class GsonConfigParser
implements ConfigParser {
    private Gson gson;

    public GsonConfigParser() {
        this(new GsonBuilder().registerTypeAdapter(Audience.class, (Object)new AudienceGsonDeserializer()).registerTypeAdapter(TypedAudience.class, (Object)new AudienceGsonDeserializer()).registerTypeAdapter(Experiment.class, (Object)new ExperimentGsonDeserializer()).registerTypeAdapter(FeatureFlag.class, (Object)new FeatureFlagGsonDeserializer()).registerTypeAdapter(Group.class, (Object)new GroupGsonDeserializer()).registerTypeAdapter(DatafileProjectConfig.class, (Object)new DatafileGsonDeserializer()).create());
    }

    GsonConfigParser(Gson gson) {
        this.gson = gson;
    }

    @Override
    public ProjectConfig parseProjectConfig(@Nonnull String json) throws ConfigParseException {
        if (json == null) {
            throw new ConfigParseException("Unable to parse null json.");
        }
        if (json.length() == 0) {
            throw new ConfigParseException("Unable to parse empty json.");
        }
        try {
            return (ProjectConfig)this.gson.fromJson(json, DatafileProjectConfig.class);
        }
        catch (Exception e) {
            throw new ConfigParseException("Unable to parse datafile: " + json, e);
        }
    }

    @Override
    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) throws JsonParseException {
        try {
            return (T)this.gson.fromJson(json, clazz);
        }
        catch (Exception e) {
            throw new JsonParseException("Unable to parse JSON string: " + e.toString());
        }
    }
}

