/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.optimizely.ab.config.parser.ConfigParser;
import com.optimizely.ab.config.parser.GsonConfigParser;
import com.optimizely.ab.config.parser.JacksonConfigParser;
import com.optimizely.ab.config.parser.JsonConfigParser;
import com.optimizely.ab.config.parser.JsonSimpleConfigParser;
import com.optimizely.ab.config.parser.MissingJsonParserException;
import com.optimizely.ab.internal.PropertyUtils;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigParser.class);

    private DefaultConfigParser() {
    }

    public static ConfigParser getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Nonnull
    private static ConfigParser create() {
        String configParserName = PropertyUtils.get("default_parser");
        if (configParserName != null) {
            try {
                ConfigParserSupplier supplier = ConfigParserSupplier.valueOf(configParserName);
                if (supplier.isPresent()) {
                    ConfigParser configParser = supplier.get();
                    logger.debug("using json parser: {}, based on override config", (Object)configParser.getClass().getSimpleName());
                    return configParser;
                }
                logger.warn("configured parser {} is not available in the classpath", (Object)configParserName);
            }
            catch (IllegalArgumentException e) {
                logger.warn("configured parser {} is not a valid value", (Object)configParserName);
            }
        }
        for (ConfigParserSupplier supplier : ConfigParserSupplier.values()) {
            if (!supplier.isPresent()) continue;
            ConfigParser configParser = supplier.get();
            logger.info("using json parser: {}", (Object)configParser.getClass().getSimpleName());
            return configParser;
        }
        throw new MissingJsonParserException("unable to locate a JSON parser. Please see <link> for more information");
    }

    static /* synthetic */ ConfigParser access$200() {
        return DefaultConfigParser.create();
    }

    private static class LazyHolder {
        private static final ConfigParser INSTANCE = DefaultConfigParser.access$200();

        private LazyHolder() {
        }
    }

    public static enum ConfigParserSupplier {
        GSON_CONFIG_PARSER("com.google.gson.Gson", () -> new GsonConfigParser()),
        JACKSON_CONFIG_PARSER("com.fasterxml.jackson.databind.ObjectMapper", () -> new JacksonConfigParser()),
        JSON_CONFIG_PARSER("org.json.JSONObject", () -> new JsonConfigParser()),
        JSON_SIMPLE_CONFIG_PARSER("org.json.simple.JSONObject", () -> new JsonSimpleConfigParser());

        private final String className;
        private final ParserSupplier supplier;

        private ConfigParserSupplier(String className, ParserSupplier supplier) {
            this.className = className;
            this.supplier = supplier;
        }

        ConfigParser get() {
            return this.supplier.get();
        }

        private boolean isPresent() {
            try {
                Class.forName(this.className);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }

    @FunctionalInterface
    public static interface ParserSupplier {
        public ConfigParser get();
    }
}

