/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Rollout;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.TypedAudience;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class DatafileGsonDeserializer
implements JsonDeserializer<ProjectConfig> {
    public ProjectConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String accountId = jsonObject.get("accountId").getAsString();
        String projectId = jsonObject.get("projectId").getAsString();
        String revision = jsonObject.get("revision").getAsString();
        String version = jsonObject.get("version").getAsString();
        int datafileVersion = Integer.parseInt(version);
        Type groupsType = new TypeToken<List<Group>>(){}.getType();
        Type experimentsType = new TypeToken<List<Experiment>>(){}.getType();
        Type attributesType = new TypeToken<List<Attribute>>(){}.getType();
        Type eventsType = new TypeToken<List<EventType>>(){}.getType();
        Type audienceType = new TypeToken<List<Audience>>(){}.getType();
        Type typedAudienceType = new TypeToken<List<TypedAudience>>(){}.getType();
        List groups = (List)context.deserialize((JsonElement)jsonObject.get("groups").getAsJsonArray(), groupsType);
        List experiments = (List)context.deserialize((JsonElement)jsonObject.get("experiments").getAsJsonArray(), experimentsType);
        List attributes = (List)context.deserialize(jsonObject.get("attributes"), attributesType);
        List events = (List)context.deserialize((JsonElement)jsonObject.get("events").getAsJsonArray(), eventsType);
        List audiences = Collections.emptyList();
        if (jsonObject.has("audiences")) {
            audiences = (List)context.deserialize((JsonElement)jsonObject.get("audiences").getAsJsonArray(), audienceType);
        }
        List typedAudiences = null;
        if (jsonObject.has("typedAudiences")) {
            typedAudiences = (List)context.deserialize((JsonElement)jsonObject.get("typedAudiences").getAsJsonArray(), typedAudienceType);
        }
        boolean anonymizeIP = false;
        if (datafileVersion >= Integer.parseInt(ProjectConfig.Version.V3.toString())) {
            anonymizeIP = jsonObject.get("anonymizeIP").getAsBoolean();
        }
        List featureFlags = null;
        List rollouts = null;
        Boolean botFiltering = null;
        if (datafileVersion >= Integer.parseInt(ProjectConfig.Version.V4.toString())) {
            Type featureFlagsType = new TypeToken<List<FeatureFlag>>(){}.getType();
            featureFlags = (List)context.deserialize((JsonElement)jsonObject.getAsJsonArray("featureFlags"), featureFlagsType);
            Type rolloutsType = new TypeToken<List<Rollout>>(){}.getType();
            rollouts = (List)context.deserialize((JsonElement)jsonObject.get("rollouts").getAsJsonArray(), rolloutsType);
            if (jsonObject.has("botFiltering")) {
                botFiltering = jsonObject.get("botFiltering").getAsBoolean();
            }
        }
        return new DatafileProjectConfig(accountId, anonymizeIP, botFiltering, projectId, revision, version, attributes, audiences, typedAudiences, events, experiments, featureFlags, groups, rollouts);
    }
}

