/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.optimizely.ab.config.audience.AndCondition;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.EmptyCondition;
import com.optimizely.ab.config.audience.NotCondition;
import com.optimizely.ab.config.audience.NullCondition;
import com.optimizely.ab.config.audience.OrCondition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.internal.InvalidAudienceCondition;
import java.io.IOException;
import java.util.ArrayList;

public class ConditionJacksonDeserializer
extends JsonDeserializer<Condition> {
    private ObjectMapper objectMapper;

    public ConditionJacksonDeserializer() {
        this(new ObjectMapper());
    }

    ConditionJacksonDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Condition deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        Condition conditions = ConditionJacksonDeserializer.parseCondition(AudienceIdCondition.class, this.objectMapper, node);
        return conditions;
    }

    private static String operand(JsonNode opNode) {
        if (opNode != null && opNode.isTextual()) {
            String op;
            switch (op = opNode.asText()) {
                case "and": 
                case "or": 
                case "not": {
                    return op;
                }
            }
        }
        return null;
    }

    protected static <T> Condition parseCondition(Class<T> clazz, ObjectMapper objectMapper, JsonNode conditionNode) throws JsonProcessingException, InvalidAudienceCondition {
        if (conditionNode.isArray()) {
            return ConditionJacksonDeserializer.parseConditions(clazz, objectMapper, conditionNode);
        }
        if (conditionNode.isTextual()) {
            if (clazz != AudienceIdCondition.class) {
                throw new InvalidAudienceCondition(String.format("Expected AudienceIdCondition got %s", clazz.getCanonicalName()));
            }
            return (Condition)objectMapper.treeToValue((TreeNode)conditionNode, AudienceIdCondition.class);
        }
        if (conditionNode.isObject()) {
            if (clazz != UserAttribute.class) {
                throw new InvalidAudienceCondition(String.format("Expected UserAttributes got %s", clazz.getCanonicalName()));
            }
            return (Condition)objectMapper.treeToValue((TreeNode)conditionNode, UserAttribute.class);
        }
        return null;
    }

    protected static <T> Condition parseConditions(Class<T> clazz, ObjectMapper objectMapper, JsonNode conditionNode) throws JsonProcessingException, InvalidAudienceCondition {
        Condition condition;
        if (conditionNode.isArray() && conditionNode.size() == 0) {
            return new EmptyCondition();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        int startingParsingIndex = 0;
        JsonNode opNode = conditionNode.get(0);
        String operand = ConditionJacksonDeserializer.operand(opNode);
        if (operand == null) {
            operand = "or";
        } else {
            startingParsingIndex = 1;
        }
        for (int i = startingParsingIndex; i < conditionNode.size(); ++i) {
            JsonNode subNode = conditionNode.get(i);
            conditions.add(ConditionJacksonDeserializer.parseCondition(clazz, objectMapper, subNode));
        }
        switch (operand) {
            case "and": {
                condition = new AndCondition(conditions);
                break;
            }
            case "or": {
                condition = new OrCondition(conditions);
                break;
            }
            case "not": {
                condition = new NotCondition(conditions.isEmpty() ? new NullCondition() : (Condition)conditions.get(0));
                break;
            }
            default: {
                condition = new OrCondition(conditions);
            }
        }
        return condition;
    }
}

