/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.parser;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.UserAttribute;
import com.optimizely.ab.internal.ConditionUtils;
import java.lang.reflect.Type;
import java.util.List;

public class AudienceGsonDeserializer
implements JsonDeserializer<Audience> {
    public Audience deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = json.getAsJsonObject();
        String id = jsonObject.get("id").getAsString();
        String name = jsonObject.get("name").getAsString();
        JsonElement conditionsElement = jsonObject.get("conditions");
        if (!typeOfT.toString().contains("TypedAudience")) {
            conditionsElement = parser.parse(jsonObject.get("conditions").getAsString());
        }
        Condition conditions = null;
        if (conditionsElement.isJsonArray()) {
            List rawObjectList = (List)gson.fromJson(conditionsElement, List.class);
            conditions = ConditionUtils.parseConditions(UserAttribute.class, rawObjectList);
        } else if (conditionsElement.isJsonObject()) {
            Object object = gson.fromJson(conditionsElement, Object.class);
            conditions = ConditionUtils.parseConditions(UserAttribute.class, object);
        }
        return new Audience(id, name, conditions);
    }
}

