/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience.match;

import com.optimizely.ab.config.audience.match.UnexpectedValueTypeException;
import com.optimizely.ab.internal.AttributesUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticVersion {
    private static final Logger logger = LoggerFactory.getLogger(SemanticVersion.class);
    private static final String BUILD_SEPERATOR = "\\+";
    private static final String PRE_RELEASE_SEPERATOR = "-";
    private final String version;

    public SemanticVersion(String version) {
        this.version = version;
    }

    public static int compare(Object o1, Object o2) throws UnexpectedValueTypeException {
        if (o1 instanceof String && o2 instanceof String) {
            SemanticVersion v1 = new SemanticVersion((String)o1);
            SemanticVersion v2 = new SemanticVersion((String)o2);
            try {
                return v1.compare(v2);
            }
            catch (Exception e) {
                logger.warn("Error comparing semantic versions", (Throwable)e);
            }
        }
        throw new UnexpectedValueTypeException();
    }

    public int compare(SemanticVersion targetedVersion) throws Exception {
        if (targetedVersion == null || AttributesUtil.stringIsNullOrEmpty(targetedVersion.version)) {
            return 0;
        }
        String[] targetedVersionParts = targetedVersion.splitSemanticVersion();
        String[] userVersionParts = this.splitSemanticVersion();
        for (int index = 0; index < targetedVersionParts.length; ++index) {
            if (userVersionParts.length <= index) {
                return targetedVersion.isPreRelease() ? 1 : -1;
            }
            Integer targetVersionPartInt = AttributesUtil.parseNumeric(targetedVersionParts[index]);
            Integer userVersionPartInt = AttributesUtil.parseNumeric(userVersionParts[index]);
            if (userVersionPartInt == null) {
                int result = userVersionParts[index].compareTo(targetedVersionParts[index]);
                if (result < 0) {
                    return targetedVersion.isPreRelease() && !this.isPreRelease() ? 1 : -1;
                }
                if (result <= 0) continue;
                return !targetedVersion.isPreRelease() && this.isPreRelease() ? -1 : 1;
            }
            if (targetVersionPartInt != null) {
                if (userVersionPartInt.equals(targetVersionPartInt)) continue;
                return userVersionPartInt < targetVersionPartInt ? -1 : 1;
            }
            return -1;
        }
        if (!targetedVersion.isPreRelease() && this.isPreRelease()) {
            return -1;
        }
        return 0;
    }

    public boolean isPreRelease() {
        int buildIndex = this.version.indexOf("+");
        int preReleaseIndex = this.version.indexOf(PRE_RELEASE_SEPERATOR);
        if (buildIndex < 0) {
            return preReleaseIndex > 0;
        }
        if (preReleaseIndex < 0) {
            return false;
        }
        return preReleaseIndex < buildIndex;
    }

    public boolean isBuild() {
        int buildIndex = this.version.indexOf("+");
        int preReleaseIndex = this.version.indexOf(PRE_RELEASE_SEPERATOR);
        if (preReleaseIndex < 0) {
            return buildIndex > 0;
        }
        if (buildIndex < 0) {
            return false;
        }
        return buildIndex < preReleaseIndex;
    }

    private int dotCount(String prefixVersion) {
        char[] vCharArray = prefixVersion.toCharArray();
        int count = 0;
        for (char c : vCharArray) {
            if (c != '.') continue;
            ++count;
        }
        return count;
    }

    private boolean isValidBuildMetadata() {
        char[] vCharArray = this.version.toCharArray();
        int count = 0;
        for (char c : vCharArray) {
            if (c != '+') continue;
            ++count;
        }
        return count > 1;
    }

    public String[] splitSemanticVersion() throws Exception {
        ArrayList<String> versionParts = new ArrayList<String>();
        String versionPrefix = "";
        String versionSuffix = "";
        if (this.version.contains(" ") || this.isValidBuildMetadata()) {
            throw new Exception("Invalid Semantic Version.");
        }
        if (this.isBuild() || this.isPreRelease()) {
            String[] partialVersionParts = this.version.split(this.isPreRelease() ? PRE_RELEASE_SEPERATOR : BUILD_SEPERATOR, 2);
            if (partialVersionParts.length <= 1) {
                throw new Exception("Invalid Semantic Version.");
            }
            versionPrefix = partialVersionParts[0];
            versionSuffix = partialVersionParts[1];
        } else {
            versionPrefix = this.version;
        }
        String[] preVersionParts = versionPrefix.split("\\.");
        if (preVersionParts.length > 3 || preVersionParts.length == 0 || this.dotCount(versionPrefix) >= preVersionParts.length) {
            throw new Exception("Invalid Semantic Version.");
        }
        for (String preVersionPart : preVersionParts) {
            if (AttributesUtil.parseNumeric(preVersionPart) != null) continue;
            throw new Exception("Invalid Semantic Version.");
        }
        Collections.addAll(versionParts, preVersionParts);
        if (!AttributesUtil.stringIsNullOrEmpty(versionSuffix)) {
            versionParts.add(versionSuffix);
        }
        return versionParts.toArray(new String[0]);
    }
}

