/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience.match;

import com.optimizely.ab.config.audience.match.DefaultMatchForLegacyAttributes;
import com.optimizely.ab.config.audience.match.ExactMatch;
import com.optimizely.ab.config.audience.match.ExistsMatch;
import com.optimizely.ab.config.audience.match.GEMatch;
import com.optimizely.ab.config.audience.match.GTMatch;
import com.optimizely.ab.config.audience.match.LEMatch;
import com.optimizely.ab.config.audience.match.LTMatch;
import com.optimizely.ab.config.audience.match.Match;
import com.optimizely.ab.config.audience.match.SemanticVersionEqualsMatch;
import com.optimizely.ab.config.audience.match.SemanticVersionGEMatch;
import com.optimizely.ab.config.audience.match.SemanticVersionGTMatch;
import com.optimizely.ab.config.audience.match.SemanticVersionLEMatch;
import com.optimizely.ab.config.audience.match.SemanticVersionLTMatch;
import com.optimizely.ab.config.audience.match.SubstringMatch;
import com.optimizely.ab.config.audience.match.UnknownMatchTypeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MatchRegistry {
    private static final Map<String, Match> registry = new ConcurrentHashMap<String, Match>();
    public static final String EXACT = "exact";
    public static final String EXISTS = "exists";
    public static final String GREATER_THAN = "gt";
    public static final String GREATER_THAN_EQ = "ge";
    public static final String LEGACY = "legacy";
    public static final String LESS_THAN = "lt";
    public static final String LESS_THAN_EQ = "le";
    public static final String SEMVER_EQ = "semver_eq";
    public static final String SEMVER_GE = "semver_ge";
    public static final String SEMVER_GT = "semver_gt";
    public static final String SEMVER_LE = "semver_le";
    public static final String SEMVER_LT = "semver_lt";
    public static final String SUBSTRING = "substring";

    public static Match getMatch(String name) throws UnknownMatchTypeException {
        Match match = registry.get(name == null ? LEGACY : name);
        if (match == null) {
            throw new UnknownMatchTypeException();
        }
        return match;
    }

    public static void register(String name, Match match) {
        registry.put(name, match);
    }

    static {
        MatchRegistry.register(EXACT, new ExactMatch());
        MatchRegistry.register(EXISTS, new ExistsMatch());
        MatchRegistry.register(GREATER_THAN, new GTMatch());
        MatchRegistry.register(GREATER_THAN_EQ, new GEMatch());
        MatchRegistry.register(LEGACY, new DefaultMatchForLegacyAttributes());
        MatchRegistry.register(LESS_THAN, new LTMatch());
        MatchRegistry.register(LESS_THAN_EQ, new LEMatch());
        MatchRegistry.register(SEMVER_EQ, new SemanticVersionEqualsMatch());
        MatchRegistry.register(SEMVER_GE, new SemanticVersionGEMatch());
        MatchRegistry.register(SEMVER_GT, new SemanticVersionGTMatch());
        MatchRegistry.register(SEMVER_LE, new SemanticVersionLEMatch());
        MatchRegistry.register(SEMVER_LT, new SemanticVersionLTMatch());
        MatchRegistry.register(SUBSTRING, new SubstringMatch());
    }
}

