/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config.audience;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.match.Match;
import com.optimizely.ab.config.audience.match.MatchRegistry;
import com.optimizely.ab.config.audience.match.UnexpectedValueTypeException;
import com.optimizely.ab.config.audience.match.UnknownMatchTypeException;
import com.optimizely.ab.config.audience.match.UnknownValueTypeException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class UserAttribute<T>
implements Condition<T> {
    private static final Logger logger = LoggerFactory.getLogger(UserAttribute.class);
    private final String name;
    private final String type;
    private final String match;
    private final Object value;

    @JsonCreator
    public UserAttribute(@JsonProperty(value="name") @Nonnull String name, @JsonProperty(value="type") @Nonnull String type, @JsonProperty(value="match") @Nullable String match, @JsonProperty(value="value") @Nullable Object value) {
        this.name = name;
        this.type = type;
        this.match = match;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getMatch() {
        return this.match;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Boolean evaluate(ProjectConfig config, Map<String, ?> attributes) {
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }
        Object userAttributeValue = attributes.get(this.name);
        if (!"custom_attribute".equals(this.type)) {
            logger.warn("Audience condition \"{}\" uses an unknown condition type. You may need to upgrade to a newer release of the Optimizely SDK.", (Object)this);
            return null;
        }
        try {
            Match matcher = MatchRegistry.getMatch(this.match);
            Boolean result = matcher.eval(this.value, userAttributeValue);
            if (result == null) {
                throw new UnknownValueTypeException();
            }
            return result;
        }
        catch (UnknownValueTypeException e) {
            if (!attributes.containsKey(this.name)) {
                logger.debug("Audience condition \"{}\" evaluated to UNKNOWN because no value was passed for user attribute \"{}\"", (Object)this, (Object)this.name);
            } else if (userAttributeValue != null) {
                logger.warn("Audience condition \"{}\" evaluated to UNKNOWN because a value of type \"{}\" was passed for user attribute \"{}\"", new Object[]{this, userAttributeValue.getClass().getCanonicalName(), this.name});
            } else {
                logger.debug("Audience condition \"{}\" evaluated to UNKNOWN because a null value was passed for user attribute \"{}\"", (Object)this, (Object)this.name);
            }
        }
        catch (UnexpectedValueTypeException | UnknownMatchTypeException e) {
            logger.warn("Audience condition \"{}\" " + e.getMessage(), (Object)this);
        }
        catch (NullPointerException e) {
            logger.error("attribute or value null for match {}", (Object)(this.match != null ? this.match : "legacy condition"), (Object)e);
        }
        return null;
    }

    public String toString() {
        String valueStr = this.value == null ? "null" : (this.value instanceof String ? String.format("'%s'", this.value) : this.value.toString());
        return "{name='" + this.name + "', type='" + this.type + "', match='" + this.match + "', value=" + valueStr + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAttribute that = (UserAttribute)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

