/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.IdKeyMapped;
import com.optimizely.ab.config.ProjectConfigUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Variation
implements IdKeyMapped {
    private final String id;
    private final String key;
    private final Boolean featureEnabled;
    private final List<FeatureVariableUsageInstance> featureVariableUsageInstances;
    private final Map<String, FeatureVariableUsageInstance> variableIdToFeatureVariableUsageInstanceMap;

    public Variation(String id, String key) {
        this(id, key, null);
    }

    public Variation(String id, String key, List<FeatureVariableUsageInstance> featureVariableUsageInstances) {
        this(id, key, false, featureVariableUsageInstances);
    }

    @JsonCreator
    public Variation(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="featureEnabled") Boolean featureEnabled, @JsonProperty(value="variables") List<FeatureVariableUsageInstance> featureVariableUsageInstances) {
        this.id = id;
        this.key = key;
        this.featureEnabled = featureEnabled != null ? featureEnabled : Boolean.valueOf(false);
        this.featureVariableUsageInstances = featureVariableUsageInstances == null ? Collections.emptyList() : featureVariableUsageInstances;
        this.variableIdToFeatureVariableUsageInstanceMap = ProjectConfigUtils.generateIdMapping(this.featureVariableUsageInstances);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Boolean getFeatureEnabled() {
        return this.featureEnabled;
    }

    @Nullable
    public List<FeatureVariableUsageInstance> getFeatureVariableUsageInstances() {
        return this.featureVariableUsageInstances;
    }

    public Map<String, FeatureVariableUsageInstance> getVariableIdToFeatureVariableUsageInstanceMap() {
        return this.variableIdToFeatureVariableUsageInstanceMap;
    }

    public boolean is(String otherKey) {
        return this.key.equals(otherKey);
    }

    public String toString() {
        return "Variation{id='" + this.id + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

