/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.Rollout;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.error.ErrorHandler;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ProjectConfig {
    public static final String RESERVED_ATTRIBUTE_PREFIX = "$opt_";

    @CheckForNull
    public Experiment getExperimentForKey(@Nonnull String var1, @Nonnull ErrorHandler var2);

    @CheckForNull
    public EventType getEventTypeForName(String var1, ErrorHandler var2);

    @Nullable
    public Experiment getExperimentForVariationId(String var1);

    public String getAttributeId(ProjectConfig var1, String var2);

    public String getAccountId();

    public String toDatafile();

    public String getProjectId();

    public String getVersion();

    public String getRevision();

    public boolean getAnonymizeIP();

    public Boolean getBotFiltering();

    public List<Group> getGroups();

    public List<Experiment> getExperiments();

    public List<Experiment> getExperimentsForEventKey(String var1);

    public List<FeatureFlag> getFeatureFlags();

    public List<Rollout> getRollouts();

    public List<Attribute> getAttributes();

    public List<EventType> getEventTypes();

    public List<Audience> getAudiences();

    public List<Audience> getTypedAudiences();

    public Audience getAudience(String var1);

    public Map<String, Experiment> getExperimentKeyMapping();

    public Map<String, Attribute> getAttributeKeyMapping();

    public Map<String, EventType> getEventNameMapping();

    public Map<String, Audience> getAudienceIdMapping();

    public Map<String, Experiment> getExperimentIdMapping();

    public Map<String, Group> getGroupIdMapping();

    public Map<String, Rollout> getRolloutIdMapping();

    public Map<String, FeatureFlag> getFeatureKeyMapping();

    public Map<String, List<String>> getExperimentFeatureKeyMapping();

    public String toString();

    public static enum Version {
        V2("2"),
        V3("3"),
        V4("4");

        private final String version;

        private Version(String version) {
            this.version = version;
        }

        public String toString() {
            return this.version;
        }
    }
}

