/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.ProjectConfigManager;
import com.optimizely.ab.notification.NotificationCenter;
import com.optimizely.ab.notification.UpdateConfigNotification;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfig;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfigManager;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfigService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollingProjectConfigManager
implements ProjectConfigManager,
AutoCloseable,
OptimizelyConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(PollingProjectConfigManager.class);
    private static final UpdateConfigNotification SIGNAL = new UpdateConfigNotification();
    private final AtomicReference<ProjectConfig> currentProjectConfig = new AtomicReference();
    private final AtomicReference<OptimizelyConfig> currentOptimizelyConfig = new AtomicReference();
    private final ScheduledExecutorService scheduledExecutorService;
    private final long period;
    private final TimeUnit timeUnit;
    private final long blockingTimeoutPeriod;
    private final TimeUnit blockingTimeoutUnit;
    private final NotificationCenter notificationCenter;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private volatile boolean started;
    private ScheduledFuture<?> scheduledFuture;

    public PollingProjectConfigManager(long period, TimeUnit timeUnit) {
        this(period, timeUnit, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new NotificationCenter());
    }

    public PollingProjectConfigManager(long period, TimeUnit timeUnit, NotificationCenter notificationCenter) {
        this(period, timeUnit, Long.MAX_VALUE, TimeUnit.MILLISECONDS, notificationCenter);
    }

    public PollingProjectConfigManager(long period, TimeUnit timeUnit, long blockingTimeoutPeriod, TimeUnit blockingTimeoutUnit, NotificationCenter notificationCenter) {
        this.period = period;
        this.timeUnit = timeUnit;
        this.blockingTimeoutPeriod = blockingTimeoutPeriod;
        this.blockingTimeoutUnit = blockingTimeoutUnit;
        this.notificationCenter = notificationCenter;
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = threadFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        });
    }

    protected abstract ProjectConfig poll();

    void setConfig(ProjectConfig projectConfig) {
        String previousRevision;
        if (projectConfig == null) {
            return;
        }
        ProjectConfig oldProjectConfig = this.currentProjectConfig.get();
        String string = previousRevision = oldProjectConfig == null ? "null" : oldProjectConfig.getRevision();
        if (projectConfig.getRevision().equals(previousRevision)) {
            return;
        }
        logger.info("New datafile set with revision: {}. Old revision: {}", (Object)projectConfig.getRevision(), (Object)previousRevision);
        this.currentProjectConfig.set(projectConfig);
        this.currentOptimizelyConfig.set(new OptimizelyConfigService(projectConfig).getConfig());
        this.countDownLatch.countDown();
        this.notificationCenter.send(SIGNAL);
    }

    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    @Override
    public ProjectConfig getConfig() {
        if (this.started) {
            try {
                boolean acquired = this.countDownLatch.await(this.blockingTimeoutPeriod, this.blockingTimeoutUnit);
                if (!acquired) {
                    logger.warn("Timeout exceeded waiting for ProjectConfig to be set, returning null.");
                    this.countDownLatch.countDown();
                }
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted waiting for valid ProjectConfig, returning null.");
            }
            return this.currentProjectConfig.get();
        }
        ProjectConfig projectConfig = this.poll();
        return projectConfig == null ? this.currentProjectConfig.get() : projectConfig;
    }

    @Override
    public OptimizelyConfig getOptimizelyConfig() {
        return this.currentOptimizelyConfig.get();
    }

    public synchronized void start() {
        if (this.started) {
            logger.warn("Manager already started.");
            return;
        }
        if (this.scheduledExecutorService.isShutdown()) {
            logger.warn("Not starting. Already in shutdown.");
            return;
        }
        ProjectConfigFetcher runnable = new ProjectConfigFetcher();
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, this.period, this.timeUnit);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            logger.warn("Not pausing. Manager has not been started.");
            return;
        }
        if (this.scheduledExecutorService.isShutdown()) {
            logger.warn("Not pausing. Already in shutdown.");
            return;
        }
        logger.info("pausing project watcher");
        this.scheduledFuture.cancel(true);
        this.started = false;
    }

    @Override
    public synchronized void close() {
        this.stop();
        this.scheduledExecutorService.shutdownNow();
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    private class ProjectConfigFetcher
    implements Runnable {
        private ProjectConfigFetcher() {
        }

        @Override
        public void run() {
            try {
                ProjectConfig projectConfig = PollingProjectConfigManager.this.poll();
                PollingProjectConfigManager.this.setConfig(projectConfig);
            }
            catch (Exception e) {
                logger.error("Uncaught exception polling for ProjectConfig.", (Throwable)e);
            }
        }
    }
}

