/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.optimizely.ab.config.IdKeyMapped;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureVariable
implements IdKeyMapped {
    public static final String STRING_TYPE = "string";
    public static final String INTEGER_TYPE = "integer";
    public static final String DOUBLE_TYPE = "double";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String JSON_TYPE = "json";
    private final String id;
    private final String key;
    private final String defaultValue;
    private final String type;
    @Nullable
    private final String subType;
    @Nullable
    private final VariableStatus status;

    @JsonCreator
    public FeatureVariable(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="defaultValue") String defaultValue, @JsonProperty(value="status") VariableStatus status, @JsonProperty(value="type") String type, @JsonProperty(value="subType") String subType) {
        this.id = id;
        this.key = key;
        this.defaultValue = defaultValue;
        this.status = status;
        this.type = type;
        this.subType = subType;
    }

    @Nullable
    public VariableStatus getStatus() {
        return this.status;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        if (this.type.equals(STRING_TYPE) && this.subType != null && this.subType.equals(JSON_TYPE)) {
            return JSON_TYPE;
        }
        return this.type;
    }

    public String toString() {
        return "FeatureVariable{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", type=" + this.type + ", subType=" + this.subType + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureVariable variable = (FeatureVariable)o;
        if (!this.id.equals(variable.id)) {
            return false;
        }
        if (!this.key.equals(variable.key)) {
            return false;
        }
        if (!this.defaultValue.equals(variable.defaultValue)) {
            return false;
        }
        if (!this.type.equals(variable.type)) {
            return false;
        }
        return this.status == variable.status;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.defaultValue.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public static enum VariableStatus {
        ACTIVE("active"),
        ARCHIVED("archived");

        private final String variableStatus;

        private VariableStatus(String variableStatus) {
            this.variableStatus = variableStatus;
        }

        @JsonValue
        public String getVariableStatus() {
            return this.variableStatus;
        }

        public static VariableStatus fromString(String variableStatusString) {
            if (variableStatusString != null) {
                for (VariableStatus variableStatusEnum : VariableStatus.values()) {
                    if (!variableStatusString.equals(variableStatusEnum.getVariableStatus())) continue;
                    return variableStatusEnum;
                }
            }
            return null;
        }
    }
}

