/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.IdKeyMapped;
import com.optimizely.ab.config.ProjectConfigUtils;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureFlag
implements IdKeyMapped {
    private final String id;
    private final String key;
    private final String rolloutId;
    private final List<String> experimentIds;
    private final List<FeatureVariable> variables;
    private final Map<String, FeatureVariable> variableKeyToFeatureVariableMap;

    @JsonCreator
    public FeatureFlag(@JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="rolloutId") String rolloutId, @JsonProperty(value="experimentIds") List<String> experimentIds, @JsonProperty(value="variables") List<FeatureVariable> variables) {
        this.id = id;
        this.key = key;
        this.rolloutId = rolloutId;
        this.experimentIds = experimentIds;
        this.variables = variables;
        this.variableKeyToFeatureVariableMap = ProjectConfigUtils.generateNameMapping(variables);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getRolloutId() {
        return this.rolloutId;
    }

    public List<String> getExperimentIds() {
        return this.experimentIds;
    }

    public List<FeatureVariable> getVariables() {
        return this.variables;
    }

    public Map<String, FeatureVariable> getVariableKeyToFeatureVariableMap() {
        return this.variableKeyToFeatureVariableMap;
    }

    public String toString() {
        return "FeatureFlag{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", rolloutId='" + this.rolloutId + '\'' + ", experimentIds=" + this.experimentIds + ", variables=" + this.variables + ", variableKeyToFeatureVariableMap=" + this.variableKeyToFeatureVariableMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag that = (FeatureFlag)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (!this.rolloutId.equals(that.rolloutId)) {
            return false;
        }
        if (!this.experimentIds.equals(that.experimentIds)) {
            return false;
        }
        if (!this.variables.equals(that.variables)) {
            return false;
        }
        return this.variableKeyToFeatureVariableMap.equals(that.variableKeyToFeatureVariableMap);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.rolloutId.hashCode();
        result = 31 * result + this.experimentIds.hashCode();
        result = 31 * result + this.variables.hashCode();
        result = 31 * result + this.variableKeyToFeatureVariableMap.hashCode();
        return result;
    }
}

