/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.UnknownExperimentException;
import com.optimizely.ab.config.Attribute;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.ProjectConfigUtils;
import com.optimizely.ab.config.Rollout;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.audience.Audience;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.config.parser.DefaultConfigParser;
import com.optimizely.ab.error.ErrorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DatafileProjectConfig
implements ProjectConfig {
    private static final List<String> supportedVersions = Arrays.asList(ProjectConfig.Version.V2.toString(), ProjectConfig.Version.V3.toString(), ProjectConfig.Version.V4.toString());
    private static final Logger logger = LoggerFactory.getLogger(DatafileProjectConfig.class);
    private final String accountId;
    private final String projectId;
    private final String revision;
    private final String version;
    private final boolean anonymizeIP;
    private final Boolean botFiltering;
    private final List<Attribute> attributes;
    private final List<Audience> audiences;
    private final List<Audience> typedAudiences;
    private final List<EventType> events;
    private final List<Experiment> experiments;
    private final List<FeatureFlag> featureFlags;
    private final List<Group> groups;
    private final List<Rollout> rollouts;
    private final Map<String, Attribute> attributeKeyMapping;
    private final Map<String, EventType> eventNameMapping;
    private final Map<String, Experiment> experimentKeyMapping;
    private final Map<String, FeatureFlag> featureKeyMapping;
    private final Map<String, Audience> audienceIdMapping;
    private final Map<String, Experiment> experimentIdMapping;
    private final Map<String, Group> groupIdMapping;
    private final Map<String, Rollout> rolloutIdMapping;
    private final Map<String, List<String>> experimentFeatureKeyMapping;
    private final Map<String, Experiment> variationIdToExperimentMapping;
    private String datafile;

    public DatafileProjectConfig(String accountId, String projectId, String version, String revision, List<Group> groups, List<Experiment> experiments, List<Attribute> attributes, List<EventType> eventType, List<Audience> audiences) {
        this(accountId, projectId, version, revision, groups, experiments, attributes, eventType, audiences, false);
    }

    public DatafileProjectConfig(String accountId, String projectId, String version, String revision, List<Group> groups, List<Experiment> experiments, List<Attribute> attributes, List<EventType> eventType, List<Audience> audiences, boolean anonymizeIP) {
        this(accountId, anonymizeIP, null, projectId, revision, version, attributes, audiences, null, eventType, experiments, null, groups, null);
    }

    public DatafileProjectConfig(String accountId, boolean anonymizeIP, Boolean botFiltering, String projectId, String revision, String version, List<Attribute> attributes, List<Audience> audiences, List<Audience> typedAudiences, List<EventType> events, List<Experiment> experiments, List<FeatureFlag> featureFlags, List<Group> groups, List<Rollout> rollouts) {
        this.accountId = accountId;
        this.projectId = projectId;
        this.version = version;
        this.revision = revision;
        this.anonymizeIP = anonymizeIP;
        this.botFiltering = botFiltering;
        this.attributes = Collections.unmodifiableList(attributes);
        this.audiences = Collections.unmodifiableList(audiences);
        this.typedAudiences = typedAudiences != null ? Collections.unmodifiableList(typedAudiences) : Collections.emptyList();
        this.events = Collections.unmodifiableList(events);
        this.featureFlags = featureFlags == null ? Collections.emptyList() : Collections.unmodifiableList(featureFlags);
        this.rollouts = rollouts == null ? Collections.emptyList() : Collections.unmodifiableList(rollouts);
        this.groups = Collections.unmodifiableList(groups);
        ArrayList<Experiment> allExperiments = new ArrayList<Experiment>();
        allExperiments.addAll(experiments);
        allExperiments.addAll(this.aggregateGroupExperiments(groups));
        this.experiments = Collections.unmodifiableList(allExperiments);
        HashMap<String, Experiment> variationIdToExperimentMap = new HashMap<String, Experiment>();
        for (Experiment experiment : this.experiments) {
            for (Variation variation : experiment.getVariations()) {
                variationIdToExperimentMap.put(variation.getId(), experiment);
            }
        }
        this.variationIdToExperimentMapping = Collections.unmodifiableMap(variationIdToExperimentMap);
        this.attributeKeyMapping = ProjectConfigUtils.generateNameMapping(attributes);
        this.eventNameMapping = ProjectConfigUtils.generateNameMapping(this.events);
        this.experimentKeyMapping = ProjectConfigUtils.generateNameMapping(this.experiments);
        this.featureKeyMapping = ProjectConfigUtils.generateNameMapping(this.featureFlags);
        if (typedAudiences == null) {
            this.audienceIdMapping = ProjectConfigUtils.generateIdMapping(audiences);
        } else {
            ArrayList<Audience> combinedList = new ArrayList<Audience>(audiences);
            combinedList.addAll(typedAudiences);
            this.audienceIdMapping = ProjectConfigUtils.generateIdMapping(combinedList);
        }
        this.experimentIdMapping = ProjectConfigUtils.generateIdMapping(this.experiments);
        this.groupIdMapping = ProjectConfigUtils.generateIdMapping(groups);
        this.rolloutIdMapping = ProjectConfigUtils.generateIdMapping(this.rollouts);
        this.experimentFeatureKeyMapping = ProjectConfigUtils.generateExperimentFeatureMapping(this.featureFlags);
    }

    @Override
    @CheckForNull
    public Experiment getExperimentForKey(@Nonnull String experimentKey, @Nonnull ErrorHandler errorHandler) {
        Experiment experiment = this.getExperimentKeyMapping().get(experimentKey);
        if (experiment == null) {
            String unknownExperimentError = String.format("Experiment \"%s\" is not in the datafile.", experimentKey);
            logger.warn(unknownExperimentError);
            errorHandler.handleError(new UnknownExperimentException(unknownExperimentError));
        }
        return experiment;
    }

    @Override
    @CheckForNull
    public EventType getEventTypeForName(String eventName, ErrorHandler errorHandler) {
        EventType eventType = this.getEventNameMapping().get(eventName);
        if (eventType == null) {
            String unknownEventTypeError = String.format("Event \"%s\" is not in the datafile.", eventName);
            logger.warn(unknownEventTypeError);
            errorHandler.handleError(new UnknownEventTypeException(unknownEventTypeError));
        }
        return eventType;
    }

    @Override
    @Nullable
    public Experiment getExperimentForVariationId(String variationId) {
        return this.variationIdToExperimentMapping.get(variationId);
    }

    private List<Experiment> aggregateGroupExperiments(List<Group> groups) {
        ArrayList<Experiment> groupExperiments = new ArrayList<Experiment>();
        for (Group group : groups) {
            groupExperiments.addAll(group.getExperiments());
        }
        return groupExperiments;
    }

    @Override
    public String getAttributeId(ProjectConfig projectConfig, String attributeKey) {
        String attributeIdOrKey = null;
        Attribute attribute = projectConfig.getAttributeKeyMapping().get(attributeKey);
        boolean hasReservedPrefix = attributeKey.startsWith("$opt_");
        if (attribute != null) {
            if (hasReservedPrefix) {
                logger.warn("Attribute {} unexpectedly has reserved prefix {}; using attribute ID instead of reserved attribute name.", (Object)attributeKey, (Object)"$opt_");
            }
            attributeIdOrKey = attribute.getId();
        } else if (hasReservedPrefix) {
            attributeIdOrKey = attributeKey;
        } else {
            logger.debug("Unrecognized Attribute \"{}\"", (Object)attributeKey);
        }
        return attributeIdOrKey;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String toDatafile() {
        return this.datafile;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public boolean getAnonymizeIP() {
        return this.anonymizeIP;
    }

    @Override
    public Boolean getBotFiltering() {
        return this.botFiltering;
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public List<Experiment> getExperiments() {
        return this.experiments;
    }

    @Override
    public List<Experiment> getExperimentsForEventKey(String eventKey) {
        EventType event = this.eventNameMapping.get(eventKey);
        if (event != null) {
            List<String> experimentIds = event.getExperimentIds();
            ArrayList<Experiment> experiments = new ArrayList<Experiment>(experimentIds.size());
            for (String experimentId : experimentIds) {
                experiments.add(this.experimentIdMapping.get(experimentId));
            }
            return experiments;
        }
        return Collections.emptyList();
    }

    @Override
    public List<FeatureFlag> getFeatureFlags() {
        return this.featureFlags;
    }

    @Override
    public List<Rollout> getRollouts() {
        return this.rollouts;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<EventType> getEventTypes() {
        return this.events;
    }

    @Override
    public List<Audience> getAudiences() {
        return this.audiences;
    }

    @Override
    public List<Audience> getTypedAudiences() {
        return this.typedAudiences;
    }

    @Override
    public Audience getAudience(String audienceId) {
        return this.audienceIdMapping.get(audienceId);
    }

    @Override
    public Map<String, Experiment> getExperimentKeyMapping() {
        return this.experimentKeyMapping;
    }

    @Override
    public Map<String, Attribute> getAttributeKeyMapping() {
        return this.attributeKeyMapping;
    }

    @Override
    public Map<String, EventType> getEventNameMapping() {
        return this.eventNameMapping;
    }

    @Override
    public Map<String, Audience> getAudienceIdMapping() {
        return this.audienceIdMapping;
    }

    @Override
    public Map<String, Experiment> getExperimentIdMapping() {
        return this.experimentIdMapping;
    }

    @Override
    public Map<String, Group> getGroupIdMapping() {
        return this.groupIdMapping;
    }

    @Override
    public Map<String, Rollout> getRolloutIdMapping() {
        return this.rolloutIdMapping;
    }

    @Override
    public Map<String, FeatureFlag> getFeatureKeyMapping() {
        return this.featureKeyMapping;
    }

    @Override
    public Map<String, List<String>> getExperimentFeatureKeyMapping() {
        return this.experimentFeatureKeyMapping;
    }

    @Override
    public String toString() {
        return "ProjectConfig{accountId='" + this.accountId + '\'' + ", projectId='" + this.projectId + '\'' + ", revision='" + this.revision + '\'' + ", version='" + this.version + '\'' + ", anonymizeIP=" + this.anonymizeIP + ", botFiltering=" + this.botFiltering + ", attributes=" + this.attributes + ", audiences=" + this.audiences + ", typedAudiences=" + this.typedAudiences + ", events=" + this.events + ", experiments=" + this.experiments + ", featureFlags=" + this.featureFlags + ", groups=" + this.groups + ", rollouts=" + this.rollouts + ", attributeKeyMapping=" + this.attributeKeyMapping + ", eventNameMapping=" + this.eventNameMapping + ", experimentKeyMapping=" + this.experimentKeyMapping + ", featureKeyMapping=" + this.featureKeyMapping + ", audienceIdMapping=" + this.audienceIdMapping + ", experimentIdMapping=" + this.experimentIdMapping + ", groupIdMapping=" + this.groupIdMapping + ", rolloutIdMapping=" + this.rolloutIdMapping + ", variationIdToExperimentMapping=" + this.variationIdToExperimentMapping + '}';
    }

    public static class Builder {
        private String datafile;

        public Builder withDatafile(String datafile) {
            this.datafile = datafile;
            return this;
        }

        public ProjectConfig build() throws ConfigParseException {
            if (this.datafile == null) {
                throw new ConfigParseException("Unable to parse null datafile.");
            }
            if (this.datafile.isEmpty()) {
                throw new ConfigParseException("Unable to parse empty datafile.");
            }
            ProjectConfig projectConfig = DefaultConfigParser.getInstance().parseProjectConfig(this.datafile);
            if (projectConfig instanceof DatafileProjectConfig) {
                ((DatafileProjectConfig)projectConfig).datafile = this.datafile;
            }
            if (!supportedVersions.contains(projectConfig.getVersion())) {
                throw new ConfigParseException("This version of the Java SDK does not support the given datafile version: " + projectConfig.getVersion());
            }
            return projectConfig;
        }
    }
}

