/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.bucketing.Decision;
import com.optimizely.ab.bucketing.UserProfile;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class UserProfileUtils {
    public static boolean isValidUserProfileMap(@Nonnull Map<String, Object> map) {
        Map experimentBucketMap;
        if (!map.containsKey("user_id")) {
            return false;
        }
        if (!map.containsKey("experiment_bucket_map")) {
            return false;
        }
        if (!(map.get("experiment_bucket_map") instanceof Map)) {
            return false;
        }
        try {
            experimentBucketMap = (Map)map.get("experiment_bucket_map");
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        for (Map decision : experimentBucketMap.values()) {
            if (decision.containsKey("variation_id")) continue;
            return false;
        }
        return true;
    }

    public static UserProfile convertMapToUserProfile(@Nonnull Map<String, Object> map) {
        String userId = (String)map.get("user_id");
        Map experimentBucketMap = (Map)map.get("experiment_bucket_map");
        HashMap<String, Decision> decisions = new HashMap<String, Decision>(experimentBucketMap.size());
        for (Map.Entry entry : experimentBucketMap.entrySet()) {
            Decision decision = new Decision((String)((Map)entry.getValue()).get("variation_id"));
            decisions.put((String)entry.getKey(), decision);
        }
        return new UserProfile(userId, decisions);
    }
}

