/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.bucketing.Decision;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class UserProfile {
    @Nonnull
    public final String userId;
    @Nonnull
    public final Map<String, Decision> experimentBucketMap;

    public UserProfile(@Nonnull String userId, @Nonnull Map<String, Decision> experimentBucketMap) {
        this.userId = userId;
        this.experimentBucketMap = experimentBucketMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfile that = (UserProfile)o;
        if (!this.userId.equals(that.userId)) {
            return false;
        }
        return this.experimentBucketMap.equals(that.experimentBucketMap);
    }

    public int hashCode() {
        int result = this.userId.hashCode();
        result = 31 * result + this.experimentBucketMap.hashCode();
        return result;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> userProfileMap = new HashMap<String, Object>(2);
        userProfileMap.put("user_id", this.userId);
        HashMap<String, Map<String, String>> decisionsMap = new HashMap<String, Map<String, String>>(this.experimentBucketMap.size());
        for (Map.Entry<String, Decision> decisionEntry : this.experimentBucketMap.entrySet()) {
            decisionsMap.put(decisionEntry.getKey(), decisionEntry.getValue().toMap());
        }
        userProfileMap.put("experiment_bucket_map", decisionsMap);
        return userProfileMap;
    }
}

