/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.bucketing.Bucketer;
import com.optimizely.ab.bucketing.Decision;
import com.optimizely.ab.bucketing.FeatureDecision;
import com.optimizely.ab.bucketing.UserProfile;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.bucketing.UserProfileUtils;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.Rollout;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.internal.ControlAttribute;
import com.optimizely.ab.internal.ExperimentUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionService {
    private final Bucketer bucketer;
    private final ErrorHandler errorHandler;
    private final UserProfileService userProfileService;
    private static final Logger logger = LoggerFactory.getLogger(DecisionService.class);
    private transient ConcurrentHashMap<String, ConcurrentHashMap<String, String>> forcedVariationMapping = new ConcurrentHashMap();

    public DecisionService(@Nonnull Bucketer bucketer, @Nonnull ErrorHandler errorHandler, @Nullable UserProfileService userProfileService) {
        this.bucketer = bucketer;
        this.errorHandler = errorHandler;
        this.userProfileService = userProfileService;
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes, @Nonnull ProjectConfig projectConfig) {
        if (!ExperimentUtils.isExperimentActive(experiment)) {
            return null;
        }
        Variation variation = this.getForcedVariation(experiment, userId);
        if (variation == null) {
            variation = this.getWhitelistedVariation(experiment, userId);
        }
        if (variation != null) {
            return variation;
        }
        UserProfile userProfile = null;
        if (this.userProfileService != null) {
            try {
                Map<String, Object> userProfileMap = this.userProfileService.lookup(userId);
                if (userProfileMap == null) {
                    logger.info("We were unable to get a user profile map from the UserProfileService.");
                } else if (UserProfileUtils.isValidUserProfileMap(userProfileMap)) {
                    userProfile = UserProfileUtils.convertMapToUserProfile(userProfileMap);
                } else {
                    logger.warn("The UserProfileService returned an invalid map.");
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                this.errorHandler.handleError(new OptimizelyRuntimeException(exception));
            }
        }
        if (userProfile != null) {
            variation = this.getStoredVariation(experiment, userProfile, projectConfig);
            if (variation != null) {
                return variation;
            }
        } else {
            userProfile = new UserProfile(userId, new HashMap<String, Decision>());
        }
        if (ExperimentUtils.doesUserMeetAudienceConditions(projectConfig, experiment, filteredAttributes, "experiment", experiment.getKey())) {
            String bucketingId = this.getBucketingId(userId, filteredAttributes);
            variation = this.bucketer.bucket(experiment, bucketingId, projectConfig);
            if (variation != null) {
                if (this.userProfileService != null) {
                    this.saveVariation(experiment, variation, userProfile);
                } else {
                    logger.debug("This decision will not be saved since the UserProfileService is null.");
                }
            }
            return variation;
        }
        logger.info("User \"{}\" does not meet conditions to be in experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
        return null;
    }

    @Nonnull
    public FeatureDecision getVariationForFeature(@Nonnull FeatureFlag featureFlag, @Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes, @Nonnull ProjectConfig projectConfig) {
        if (!featureFlag.getExperimentIds().isEmpty()) {
            for (String experimentId : featureFlag.getExperimentIds()) {
                Experiment experiment = projectConfig.getExperimentIdMapping().get(experimentId);
                Variation variation = this.getVariation(experiment, userId, filteredAttributes, projectConfig);
                if (variation == null) continue;
                return new FeatureDecision(experiment, variation, FeatureDecision.DecisionSource.FEATURE_TEST);
            }
        } else {
            logger.info("The feature flag \"{}\" is not used in any experiments.", (Object)featureFlag.getKey());
        }
        FeatureDecision featureDecision = this.getVariationForFeatureInRollout(featureFlag, userId, filteredAttributes, projectConfig);
        if (featureDecision.variation == null) {
            logger.info("The user \"{}\" was not bucketed into a rollout for feature flag \"{}\".", (Object)userId, (Object)featureFlag.getKey());
        } else {
            logger.info("The user \"{}\" was bucketed into a rollout for feature flag \"{}\".", (Object)userId, (Object)featureFlag.getKey());
        }
        return featureDecision;
    }

    @Nonnull
    FeatureDecision getVariationForFeatureInRollout(@Nonnull FeatureFlag featureFlag, @Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes, @Nonnull ProjectConfig projectConfig) {
        Experiment finalRule;
        Variation variation;
        if (featureFlag.getRolloutId().isEmpty()) {
            logger.info("The feature flag \"{}\" is not used in a rollout.", (Object)featureFlag.getKey());
            return new FeatureDecision(null, null, null);
        }
        Rollout rollout = projectConfig.getRolloutIdMapping().get(featureFlag.getRolloutId());
        if (rollout == null) {
            logger.error("The rollout with id \"{}\" was not found in the datafile for feature flag \"{}\".", (Object)featureFlag.getRolloutId(), (Object)featureFlag.getKey());
            return new FeatureDecision(null, null, null);
        }
        int rolloutRulesLength = rollout.getExperiments().size();
        String bucketingId = this.getBucketingId(userId, filteredAttributes);
        for (int i = 0; i < rolloutRulesLength - 1; ++i) {
            Experiment rolloutRule = rollout.getExperiments().get(i);
            if (ExperimentUtils.doesUserMeetAudienceConditions(projectConfig, rolloutRule, filteredAttributes, "rule", Integer.toString(i + 1))) {
                variation = this.bucketer.bucket(rolloutRule, bucketingId, projectConfig);
                if (variation == null) break;
                return new FeatureDecision(rolloutRule, variation, FeatureDecision.DecisionSource.ROLLOUT);
            }
            logger.debug("User \"{}\" does not meet conditions for targeting rule \"{}\".", (Object)userId, (Object)(i + 1));
        }
        if (ExperimentUtils.doesUserMeetAudienceConditions(projectConfig, finalRule = rollout.getExperiments().get(rolloutRulesLength - 1), filteredAttributes, "rule", "Everyone Else") && (variation = this.bucketer.bucket(finalRule, bucketingId, projectConfig)) != null) {
            logger.debug("User \"{}\" meets conditions for targeting rule \"Everyone Else\".", (Object)userId);
            return new FeatureDecision(finalRule, variation, FeatureDecision.DecisionSource.ROLLOUT);
        }
        return new FeatureDecision(null, null, null);
    }

    @Nullable
    Variation getWhitelistedVariation(@Nonnull Experiment experiment, @Nonnull String userId) {
        Map<String, String> userIdToVariationKeyMap = experiment.getUserIdToVariationKeyMap();
        if (userIdToVariationKeyMap.containsKey(userId)) {
            String forcedVariationKey = userIdToVariationKeyMap.get(userId);
            Variation forcedVariation = experiment.getVariationKeyToVariationMap().get(forcedVariationKey);
            if (forcedVariation != null) {
                logger.info("User \"{}\" is forced in variation \"{}\".", (Object)userId, (Object)forcedVariationKey);
            } else {
                logger.error("Variation \"{}\" is not in the datafile. Not activating user \"{}\".", (Object)forcedVariationKey, (Object)userId);
            }
            return forcedVariation;
        }
        return null;
    }

    @Nullable
    Variation getStoredVariation(@Nonnull Experiment experiment, @Nonnull UserProfile userProfile, @Nonnull ProjectConfig projectConfig) {
        String experimentId = experiment.getId();
        String experimentKey = experiment.getKey();
        Decision decision = userProfile.experimentBucketMap.get(experimentId);
        if (decision != null) {
            String variationId = decision.variationId;
            Variation savedVariation = projectConfig.getExperimentIdMapping().get(experimentId).getVariationIdToVariationMap().get(variationId);
            if (savedVariation != null) {
                logger.info("Returning previously activated variation \"{}\" of experiment \"{}\" for user \"{}\" from user profile.", new Object[]{savedVariation.getKey(), experimentKey, userProfile.userId});
                return savedVariation;
            }
            logger.info("User \"{}\" was previously bucketed into variation with ID \"{}\" for experiment \"{}\", but no matching variation was found for that user. We will re-bucket the user.", new Object[]{userProfile.userId, variationId, experimentKey});
            return null;
        }
        logger.info("No previously activated variation of experiment \"{}\" for user \"{}\" found in user profile.", (Object)experimentKey, (Object)userProfile.userId);
        return null;
    }

    void saveVariation(@Nonnull Experiment experiment, @Nonnull Variation variation, @Nonnull UserProfile userProfile) {
        if (this.userProfileService != null) {
            Decision decision;
            String experimentId = experiment.getId();
            String variationId = variation.getId();
            if (userProfile.experimentBucketMap.containsKey(experimentId)) {
                decision = userProfile.experimentBucketMap.get(experimentId);
                decision.variationId = variationId;
            } else {
                decision = new Decision(variationId);
            }
            userProfile.experimentBucketMap.put(experimentId, decision);
            try {
                this.userProfileService.save(userProfile.toMap());
                logger.info("Saved variation \"{}\" of experiment \"{}\" for user \"{}\".", new Object[]{variationId, experimentId, userProfile.userId});
            }
            catch (Exception exception) {
                logger.warn("Failed to save variation \"{}\" of experiment \"{}\" for user \"{}\".", new Object[]{variationId, experimentId, userProfile.userId});
                this.errorHandler.handleError(new OptimizelyRuntimeException(exception));
            }
        }
    }

    String getBucketingId(@Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes) {
        String bucketingId = userId;
        if (filteredAttributes != null && filteredAttributes.containsKey(ControlAttribute.BUCKETING_ATTRIBUTE.toString())) {
            if (String.class.isInstance(filteredAttributes.get(ControlAttribute.BUCKETING_ATTRIBUTE.toString()))) {
                bucketingId = (String)filteredAttributes.get(ControlAttribute.BUCKETING_ATTRIBUTE.toString());
                logger.debug("BucketingId is valid: \"{}\"", (Object)bucketingId);
            } else {
                logger.warn("BucketingID attribute is not a string. Defaulted to userId");
            }
        }
        return bucketingId;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, String>> getForcedVariationMapping() {
        return this.forcedVariationMapping;
    }

    public boolean setForcedVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nullable String variationKey) {
        Variation variation = null;
        if (variationKey != null && (variation = experiment.getVariationKeyToVariationMap().get(variationKey)) == null) {
            logger.error("Variation {} does not exist for experiment {}", (Object)variationKey, (Object)experiment.getKey());
            return false;
        }
        if (!this.validateUserId(userId)) {
            return false;
        }
        if (!this.forcedVariationMapping.containsKey(userId)) {
            this.forcedVariationMapping.putIfAbsent(userId, new ConcurrentHashMap());
        }
        ConcurrentHashMap<String, String> experimentToVariation = this.forcedVariationMapping.get(userId);
        boolean retVal = true;
        if (variationKey == null) {
            String removedVariationId = experimentToVariation.remove(experiment.getId());
            if (removedVariationId != null) {
                Variation removedVariation = experiment.getVariationIdToVariationMap().get(removedVariationId);
                if (removedVariation != null) {
                    logger.debug("Variation mapped to experiment \"{}\" has been removed for user \"{}\"", (Object)experiment.getKey(), (Object)userId);
                } else {
                    logger.debug("Removed forced variation that did not exist in experiment");
                }
            } else {
                logger.debug("No variation for experiment {}", (Object)experiment.getKey());
                retVal = false;
            }
        } else {
            Variation previousVariation;
            String previous = experimentToVariation.put(experiment.getId(), variation.getId());
            logger.debug("Set variation \"{}\" for experiment \"{}\" and user \"{}\" in the forced variation map.", new Object[]{variation.getKey(), experiment.getKey(), userId});
            if (previous != null && (previousVariation = experiment.getVariationIdToVariationMap().get(previous)) != null) {
                logger.debug("forced variation {} replaced forced variation {} in forced variation map.", (Object)variation.getKey(), (Object)previousVariation.getKey());
            }
        }
        return retVal;
    }

    @Nullable
    public Variation getForcedVariation(@Nonnull Experiment experiment, @Nonnull String userId) {
        if (!this.validateUserId(userId)) {
            return null;
        }
        Map experimentToVariation = this.getForcedVariationMapping().get(userId);
        if (experimentToVariation != null) {
            String variationId = (String)experimentToVariation.get(experiment.getId());
            if (variationId != null) {
                Variation variation = experiment.getVariationIdToVariationMap().get(variationId);
                if (variation != null) {
                    logger.debug("Variation \"{}\" is mapped to experiment \"{}\" and user \"{}\" in the forced variation map", new Object[]{variation.getKey(), experiment.getKey(), userId});
                    return variation;
                }
            } else {
                logger.debug("No variation for experiment \"{}\" mapped to user \"{}\" in the forced variation map ", (Object)experiment.getKey(), (Object)userId);
            }
        }
        return null;
    }

    private boolean validateUserId(String userId) {
        if (userId == null) {
            logger.error("User ID is invalid");
            return false;
        }
        return true;
    }
}

