/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.bucketing;

import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.bucketing.internal.MurmurHash3;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Group;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.TrafficAllocation;
import com.optimizely.ab.config.Variation;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class Bucketer {
    private static final Logger logger = LoggerFactory.getLogger(Bucketer.class);
    private static final int MURMUR_HASH_SEED = 1;
    @VisibleForTesting
    static final int MAX_TRAFFIC_VALUE = 10000;

    private String bucketToEntity(int bucketValue, List<TrafficAllocation> trafficAllocations) {
        for (TrafficAllocation currAllocation : trafficAllocations) {
            int currentEndOfRange = currAllocation.getEndOfRange();
            if (bucketValue >= currentEndOfRange) continue;
            if (currAllocation.getEntityId().isEmpty()) {
                return null;
            }
            return currAllocation.getEntityId();
        }
        return null;
    }

    private Experiment bucketToExperiment(@Nonnull Group group, @Nonnull String bucketingId, @Nonnull ProjectConfig projectConfig) {
        String bucketKey = bucketingId + group.getId();
        List<TrafficAllocation> trafficAllocations = group.getTrafficAllocation();
        int hashCode = MurmurHash3.murmurhash3_x86_32(bucketKey, 0, bucketKey.length(), 1);
        int bucketValue = this.generateBucketValue(hashCode);
        logger.debug("Assigned bucket {} to user with bucketingId \"{}\" during experiment bucketing.", (Object)bucketValue, (Object)bucketingId);
        String bucketedExperimentId = this.bucketToEntity(bucketValue, trafficAllocations);
        if (bucketedExperimentId != null) {
            return projectConfig.getExperimentIdMapping().get(bucketedExperimentId);
        }
        return null;
    }

    private Variation bucketToVariation(@Nonnull Experiment experiment, @Nonnull String bucketingId) {
        String experimentId = experiment.getId();
        String experimentKey = experiment.getKey();
        String combinedBucketId = bucketingId + experimentId;
        List<TrafficAllocation> trafficAllocations = experiment.getTrafficAllocation();
        int hashCode = MurmurHash3.murmurhash3_x86_32(combinedBucketId, 0, combinedBucketId.length(), 1);
        int bucketValue = this.generateBucketValue(hashCode);
        logger.debug("Assigned bucket {} to user with bucketingId \"{}\" when bucketing to a variation.", (Object)bucketValue, (Object)bucketingId);
        String bucketedVariationId = this.bucketToEntity(bucketValue, trafficAllocations);
        if (bucketedVariationId != null) {
            Variation bucketedVariation = experiment.getVariationIdToVariationMap().get(bucketedVariationId);
            String variationKey = bucketedVariation.getKey();
            logger.info("User with bucketingId \"{}\" is in variation \"{}\" of experiment \"{}\".", new Object[]{bucketingId, variationKey, experimentKey});
            return bucketedVariation;
        }
        logger.info("User with bucketingId \"{}\" is not in any variation of experiment \"{}\".", (Object)bucketingId, (Object)experimentKey);
        return null;
    }

    @Nullable
    public Variation bucket(@Nonnull Experiment experiment, @Nonnull String bucketingId, @Nonnull ProjectConfig projectConfig) {
        Group experimentGroup;
        String groupId = experiment.getGroupId();
        if (!groupId.isEmpty() && (experimentGroup = projectConfig.getGroupIdMapping().get(groupId)).getPolicy().equals("random")) {
            Experiment bucketedExperiment = this.bucketToExperiment(experimentGroup, bucketingId, projectConfig);
            if (bucketedExperiment == null) {
                logger.info("User with bucketingId \"{}\" is not in any experiment of group {}.", (Object)bucketingId, (Object)experimentGroup.getId());
                return null;
            }
            if (!bucketedExperiment.getId().equals(experiment.getId())) {
                logger.info("User with bucketingId \"{}\" is not in experiment \"{}\" of group {}.", new Object[]{bucketingId, experiment.getKey(), experimentGroup.getId()});
                return null;
            }
            logger.info("User with bucketingId \"{}\" is in experiment \"{}\" of group {}.", new Object[]{bucketingId, experiment.getKey(), experimentGroup.getId()});
        }
        return this.bucketToVariation(experiment, bucketingId);
    }

    @VisibleForTesting
    int generateBucketValue(int hashCode) {
        double ratio = (double)((long)hashCode & 0xFFFFFFFFL) / Math.pow(2.0, 32.0);
        return (int)Math.floor(10000.0 * ratio);
    }
}

