/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab;

import com.optimizely.ab.OptimizelyRuntimeException;
import com.optimizely.ab.UnknownEventTypeException;
import com.optimizely.ab.UnknownExperimentException;
import com.optimizely.ab.annotations.VisibleForTesting;
import com.optimizely.ab.bucketing.Bucketer;
import com.optimizely.ab.bucketing.DecisionService;
import com.optimizely.ab.bucketing.FeatureDecision;
import com.optimizely.ab.bucketing.UserProfileService;
import com.optimizely.ab.config.AtomicProjectConfigManager;
import com.optimizely.ab.config.DatafileProjectConfig;
import com.optimizely.ab.config.EventType;
import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.FeatureFlag;
import com.optimizely.ab.config.FeatureVariable;
import com.optimizely.ab.config.FeatureVariableUsageInstance;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.ProjectConfigManager;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.config.parser.ConfigParseException;
import com.optimizely.ab.error.ErrorHandler;
import com.optimizely.ab.error.NoOpErrorHandler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.EventProcessor;
import com.optimizely.ab.event.ForwardingEventProcessor;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.event.NoopEventHandler;
import com.optimizely.ab.event.internal.ClientEngineInfo;
import com.optimizely.ab.event.internal.ConversionEvent;
import com.optimizely.ab.event.internal.EventFactory;
import com.optimizely.ab.event.internal.ImpressionEvent;
import com.optimizely.ab.event.internal.UserEventFactory;
import com.optimizely.ab.event.internal.payload.EventBatch;
import com.optimizely.ab.internal.SafetyUtils;
import com.optimizely.ab.notification.ActivateNotification;
import com.optimizely.ab.notification.DecisionNotification;
import com.optimizely.ab.notification.FeatureTestSourceInfo;
import com.optimizely.ab.notification.NotificationCenter;
import com.optimizely.ab.notification.NotificationHandler;
import com.optimizely.ab.notification.RolloutSourceInfo;
import com.optimizely.ab.notification.SourceInfo;
import com.optimizely.ab.notification.TrackNotification;
import com.optimizely.ab.notification.UpdateConfigNotification;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfig;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfigManager;
import com.optimizely.ab.optimizelyconfig.OptimizelyConfigService;
import com.optimizely.ab.optimizelyjson.OptimizelyJSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Optimizely
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Optimizely.class);
    @VisibleForTesting
    final DecisionService decisionService;
    @Deprecated
    @VisibleForTesting
    final EventHandler eventHandler;
    @VisibleForTesting
    final EventProcessor eventProcessor;
    @VisibleForTesting
    final ErrorHandler errorHandler;
    private final ProjectConfigManager projectConfigManager;
    @Nullable
    private final OptimizelyConfigManager optimizelyConfigManager;
    public final NotificationCenter notificationCenter;
    @Nullable
    private final UserProfileService userProfileService;

    private Optimizely(@Nonnull EventHandler eventHandler, @Nonnull EventProcessor eventProcessor, @Nonnull ErrorHandler errorHandler, @Nonnull DecisionService decisionService, @Nullable UserProfileService userProfileService, @Nonnull ProjectConfigManager projectConfigManager, @Nullable OptimizelyConfigManager optimizelyConfigManager, @Nonnull NotificationCenter notificationCenter) {
        this.eventHandler = eventHandler;
        this.eventProcessor = eventProcessor;
        this.errorHandler = errorHandler;
        this.decisionService = decisionService;
        this.userProfileService = userProfileService;
        this.projectConfigManager = projectConfigManager;
        this.optimizelyConfigManager = optimizelyConfigManager;
        this.notificationCenter = notificationCenter;
    }

    public boolean isValid() {
        return this.getProjectConfig() != null;
    }

    @Override
    public void close() {
        SafetyUtils.tryClose(this.eventProcessor);
        SafetyUtils.tryClose(this.eventHandler);
        SafetyUtils.tryClose(this.projectConfigManager);
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.activate(experimentKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownExperimentException {
        if (experimentKey == null) {
            logger.error("The experimentKey parameter must be nonnull.");
            return null;
        }
        if (!this.validateUserId(userId)) {
            logger.info("Not activating user for experiment \"{}\".", (Object)experimentKey);
            return null;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing activate call.");
            return null;
        }
        Experiment experiment = projectConfig.getExperimentForKey(experimentKey, this.errorHandler);
        if (experiment == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experimentKey);
            return null;
        }
        return this.activate(projectConfig, experiment, userId, attributes);
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId) {
        return this.activate(experiment, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation activate(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        return this.activate(this.getProjectConfig(), experiment, userId, attributes);
    }

    @Nullable
    private Variation activate(@Nullable ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing activate call.");
            return null;
        }
        if (!this.validateUserId(userId)) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            return null;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        Variation variation = this.getVariation(projectConfig, experiment, userId, copiedAttributes);
        if (variation == null) {
            logger.info("Not activating user \"{}\" for experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
            return null;
        }
        this.sendImpression(projectConfig, experiment, userId, copiedAttributes, variation);
        return variation;
    }

    private void sendImpression(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> filteredAttributes, @Nonnull Variation variation) {
        if (!experiment.isRunning()) {
            logger.info("Experiment has \"Launched\" status so not dispatching event during activation.");
            return;
        }
        ImpressionEvent userEvent = UserEventFactory.createImpressionEvent(projectConfig, experiment, variation, userId, filteredAttributes);
        this.eventProcessor.process(userEvent);
        logger.info("Activating user \"{}\" in experiment \"{}\".", (Object)userId, (Object)experiment.getKey());
        if (this.notificationCenter.getNotificationManager(ActivateNotification.class).size() > 0) {
            LogEvent impressionEvent = EventFactory.createLogEvent(userEvent);
            ActivateNotification activateNotification = new ActivateNotification(experiment, userId, filteredAttributes, variation, impressionEvent);
            this.notificationCenter.send(activateNotification);
        }
    }

    public void track(@Nonnull String eventName, @Nonnull String userId) throws UnknownEventTypeException {
        this.track(eventName, userId, Collections.emptyMap(), Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownEventTypeException {
        this.track(eventName, userId, attributes, Collections.emptyMap());
    }

    public void track(@Nonnull String eventName, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull Map<String, ?> eventTags) throws UnknownEventTypeException {
        if (!this.validateUserId(userId)) {
            logger.info("Not tracking event \"{}\".", (Object)eventName);
            return;
        }
        if (eventName == null || eventName.trim().isEmpty()) {
            logger.error("Event Key is null or empty when non-null and non-empty String was expected.");
            logger.info("Not tracking event for user \"{}\".", (Object)userId);
            return;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        EventType eventType = projectConfig.getEventTypeForName(eventName, this.errorHandler);
        if (eventType == null) {
            logger.info("Not tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
            return;
        }
        if (eventTags == null) {
            logger.warn("Event tags is null when non-null was expected. Defaulting to an empty event tags map.");
        }
        ConversionEvent userEvent = UserEventFactory.createConversionEvent(projectConfig, userId, eventType.getId(), eventType.getKey(), copiedAttributes, eventTags);
        this.eventProcessor.process(userEvent);
        logger.info("Tracking event \"{}\" for user \"{}\".", (Object)eventName, (Object)userId);
        if (this.notificationCenter.getNotificationManager(TrackNotification.class).size() > 0) {
            LogEvent conversionEvent = EventFactory.createLogEvent(userEvent);
            TrackNotification notification = new TrackNotification(eventName, userId, copiedAttributes, eventTags, conversionEvent);
            this.notificationCenter.send(notification);
        }
    }

    @Nonnull
    public Boolean isFeatureEnabled(@Nonnull String featureKey, @Nonnull String userId) {
        return this.isFeatureEnabled(featureKey, userId, Collections.emptyMap());
    }

    @Nonnull
    public Boolean isFeatureEnabled(@Nonnull String featureKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return false;
        }
        return this.isFeatureEnabled(projectConfig, featureKey, userId, attributes);
    }

    @Nonnull
    private Boolean isFeatureEnabled(@Nonnull ProjectConfig projectConfig, @Nonnull String featureKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (featureKey == null) {
            logger.warn("The featureKey parameter must be nonnull.");
            return false;
        }
        if (userId == null) {
            logger.warn("The userId parameter must be nonnull.");
            return false;
        }
        FeatureFlag featureFlag = projectConfig.getFeatureKeyMapping().get(featureKey);
        if (featureFlag == null) {
            logger.info("No feature flag was found for key \"{}\".", (Object)featureKey);
            return false;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        FeatureDecision.DecisionSource decisionSource = FeatureDecision.DecisionSource.ROLLOUT;
        FeatureDecision featureDecision = this.decisionService.getVariationForFeature(featureFlag, userId, copiedAttributes, projectConfig);
        Boolean featureEnabled = false;
        SourceInfo sourceInfo = new RolloutSourceInfo();
        if (featureDecision.variation != null) {
            if (featureDecision.decisionSource.equals((Object)FeatureDecision.DecisionSource.FEATURE_TEST)) {
                this.sendImpression(projectConfig, featureDecision.experiment, userId, copiedAttributes, featureDecision.variation);
                decisionSource = featureDecision.decisionSource;
                sourceInfo = new FeatureTestSourceInfo(featureDecision.experiment.getKey(), featureDecision.variation.getKey());
            } else {
                logger.info("The user \"{}\" is not included in an experiment for feature \"{}\".", (Object)userId, (Object)featureKey);
            }
            if (featureDecision.variation.getFeatureEnabled().booleanValue()) {
                featureEnabled = true;
            }
        }
        DecisionNotification decisionNotification = DecisionNotification.newFeatureDecisionNotificationBuilder().withUserId(userId).withAttributes(copiedAttributes).withFeatureKey(featureKey).withFeatureEnabled(featureEnabled).withSource(decisionSource).withSourceInfo(sourceInfo).build();
        this.notificationCenter.send(decisionNotification);
        logger.info("Feature \"{}\" is enabled for user \"{}\"? {}", new Object[]{featureKey, userId, featureEnabled});
        return featureEnabled;
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableBoolean(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Boolean getFeatureVariableBoolean(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        return (Boolean)this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, "boolean");
    }

    @Nullable
    public Double getFeatureVariableDouble(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableDouble(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Double getFeatureVariableDouble(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        Double variableValue = null;
        try {
            variableValue = (Double)this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, "double");
        }
        catch (Exception exception) {
            logger.error("NumberFormatException while trying to parse \"" + variableValue + "\" as Double. " + exception);
        }
        return variableValue;
    }

    @Nullable
    public Integer getFeatureVariableInteger(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableInteger(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Integer getFeatureVariableInteger(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        Integer variableValue = null;
        try {
            variableValue = (Integer)this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, "integer");
        }
        catch (Exception exception) {
            logger.error("NumberFormatException while trying to parse value as Integer. " + exception.toString());
        }
        return variableValue;
    }

    @Nullable
    public String getFeatureVariableString(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableString(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public String getFeatureVariableString(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        return (String)this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, "string");
    }

    @Nullable
    public OptimizelyJSON getFeatureVariableJSON(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId) {
        return this.getFeatureVariableJSON(featureKey, variableKey, userId, Collections.emptyMap());
    }

    @Nullable
    public OptimizelyJSON getFeatureVariableJSON(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        return (OptimizelyJSON)this.getFeatureVariableValueForType(featureKey, variableKey, userId, attributes, "json");
    }

    @VisibleForTesting
    <T> T getFeatureVariableValueForType(@Nonnull String featureKey, @Nonnull String variableKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull String variableType) {
        Map<String, Object> convertedValue;
        if (featureKey == null) {
            logger.warn("The featureKey parameter must be nonnull.");
            return null;
        }
        if (variableKey == null) {
            logger.warn("The variableKey parameter must be nonnull.");
            return null;
        }
        if (userId == null) {
            logger.warn("The userId parameter must be nonnull.");
            return null;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing getFeatureVariableValueForType call. type: {}", (Object)variableType);
            return null;
        }
        FeatureFlag featureFlag = projectConfig.getFeatureKeyMapping().get(featureKey);
        if (featureFlag == null) {
            logger.info("No feature flag was found for key \"{}\".", (Object)featureKey);
            return null;
        }
        FeatureVariable variable = featureFlag.getVariableKeyToFeatureVariableMap().get(variableKey);
        if (variable == null) {
            logger.info("No feature variable was found for key \"{}\" in feature flag \"{}\".", (Object)variableKey, (Object)featureKey);
            return null;
        }
        if (!variable.getType().equals(variableType)) {
            logger.info("The feature variable \"" + variableKey + "\" is actually of type \"" + variable.getType().toString() + "\" type. You tried to access it as type \"" + variableType.toString() + "\". Please use the appropriate feature variable accessor.");
            return null;
        }
        String variableValue = variable.getDefaultValue();
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        FeatureDecision featureDecision = this.decisionService.getVariationForFeature(featureFlag, userId, copiedAttributes, projectConfig);
        Boolean featureEnabled = false;
        if (featureDecision.variation != null) {
            if (featureDecision.variation.getFeatureEnabled().booleanValue()) {
                FeatureVariableUsageInstance featureVariableUsageInstance = featureDecision.variation.getVariableIdToFeatureVariableUsageInstanceMap().get(variable.getId());
                if (featureVariableUsageInstance != null) {
                    variableValue = featureVariableUsageInstance.getValue();
                    logger.info("Got variable value \"{}\" for variable \"{}\" of feature flag \"{}\".", new Object[]{variableValue, variableKey, featureKey});
                } else {
                    variableValue = variable.getDefaultValue();
                    logger.info("Value is not defined for variable \"{}\". Returning default value \"{}\".", (Object)variableKey, (Object)variableValue);
                }
            } else {
                logger.info("Feature \"{}\" is not enabled for user \"{}\". Returning the default variable value \"{}\".", new Object[]{featureKey, userId, variableValue});
            }
            featureEnabled = featureDecision.variation.getFeatureEnabled();
        } else {
            logger.info("User \"{}\" was not bucketed into any variation for feature flag \"{}\". The default value \"{}\" for \"{}\" is being returned.", new Object[]{userId, featureKey, variableValue, variableKey});
        }
        Map<String, Object> notificationValue = convertedValue = this.convertStringToType(variableValue, variableType);
        if (convertedValue instanceof OptimizelyJSON) {
            notificationValue = ((OptimizelyJSON)((Object)convertedValue)).toMap();
        }
        DecisionNotification decisionNotification = DecisionNotification.newFeatureVariableDecisionNotificationBuilder().withUserId(userId).withAttributes(copiedAttributes).withFeatureKey(featureKey).withFeatureEnabled(featureEnabled).withVariableKey(variableKey).withVariableType(variableType).withVariableValue(notificationValue).withFeatureDecision(featureDecision).build();
        this.notificationCenter.send(decisionNotification);
        return (T)convertedValue;
    }

    @VisibleForTesting
    Object convertStringToType(String variableValue, String type) {
        if (variableValue != null) {
            switch (type) {
                case "double": {
                    try {
                        return Double.parseDouble(variableValue);
                    }
                    catch (NumberFormatException exception) {
                        logger.error("NumberFormatException while trying to parse \"" + variableValue + "\" as Double. " + exception);
                        break;
                    }
                }
                case "string": {
                    return variableValue;
                }
                case "boolean": {
                    return Boolean.parseBoolean(variableValue);
                }
                case "integer": {
                    try {
                        return Integer.parseInt(variableValue);
                    }
                    catch (NumberFormatException exception) {
                        logger.error("NumberFormatException while trying to parse \"" + variableValue + "\" as Integer. " + exception.toString());
                        break;
                    }
                }
                case "json": {
                    return new OptimizelyJSON(variableValue);
                }
                default: {
                    return variableValue;
                }
            }
        }
        return null;
    }

    @Nullable
    public OptimizelyJSON getAllFeatureVariables(@Nonnull String featureKey, @Nonnull String userId) {
        return this.getAllFeatureVariables(featureKey, userId, Collections.emptyMap());
    }

    @Nullable
    public OptimizelyJSON getAllFeatureVariables(@Nonnull String featureKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (featureKey == null) {
            logger.warn("The featureKey parameter must be nonnull.");
            return null;
        }
        if (userId == null) {
            logger.warn("The userId parameter must be nonnull.");
            return null;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing getAllFeatureVariableValues call. type");
            return null;
        }
        FeatureFlag featureFlag = projectConfig.getFeatureKeyMapping().get(featureKey);
        if (featureFlag == null) {
            logger.info("No feature flag was found for key \"{}\".", (Object)featureKey);
            return null;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        FeatureDecision featureDecision = this.decisionService.getVariationForFeature(featureFlag, userId, copiedAttributes, projectConfig);
        Boolean featureEnabled = false;
        Variation variation = featureDecision.variation;
        if (variation != null) {
            featureEnabled = variation.getFeatureEnabled();
            if (featureEnabled.booleanValue()) {
                logger.info("Feature \"{}\" is enabled for user \"{}\".", (Object)featureKey, (Object)userId);
            } else {
                logger.info("Feature \"{}\" is not enabled for user \"{}\".", (Object)featureKey, (Object)userId);
            }
        } else {
            logger.info("User \"{}\" was not bucketed into any variation for feature flag \"{}\". The default values are being returned.", (Object)userId, (Object)featureKey);
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        for (FeatureVariable variable : featureFlag.getVariables()) {
            Map<String, Object> convertedValue;
            FeatureVariableUsageInstance instance;
            String value = variable.getDefaultValue();
            if (featureEnabled.booleanValue() && (instance = variation.getVariableIdToFeatureVariableUsageInstanceMap().get(variable.getId())) != null) {
                value = instance.getValue();
            }
            if ((convertedValue = this.convertStringToType(value, variable.getType())) instanceof OptimizelyJSON) {
                convertedValue = ((OptimizelyJSON)((Object)convertedValue)).toMap();
            }
            valuesMap.put(variable.getKey(), convertedValue);
        }
        DecisionNotification decisionNotification = DecisionNotification.newFeatureVariableDecisionNotificationBuilder().withUserId(userId).withAttributes(copiedAttributes).withFeatureKey(featureKey).withFeatureEnabled(featureEnabled).withVariableValues(valuesMap).withFeatureDecision(featureDecision).build();
        this.notificationCenter.send(decisionNotification);
        return new OptimizelyJSON(valuesMap);
    }

    public List<String> getEnabledFeatures(@Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        ArrayList<String> enabledFeaturesList = new ArrayList<String>();
        if (!this.validateUserId(userId)) {
            return enabledFeaturesList;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return enabledFeaturesList;
        }
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        for (FeatureFlag featureFlag : projectConfig.getFeatureFlags()) {
            String featureKey = featureFlag.getKey();
            if (!this.isFeatureEnabled(projectConfig, featureKey, userId, copiedAttributes).booleanValue()) continue;
            enabledFeaturesList.add(featureKey);
        }
        return enabledFeaturesList;
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experiment, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownExperimentException {
        return this.getVariation(this.getProjectConfig(), experiment, userId, attributes);
    }

    @Nullable
    private Variation getVariation(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes) throws UnknownExperimentException {
        Map<String, ?> copiedAttributes = this.copyAttributes(attributes);
        Variation variation = this.decisionService.getVariation(experiment, userId, copiedAttributes, projectConfig);
        String notificationType = NotificationCenter.DecisionNotificationType.AB_TEST.toString();
        if (projectConfig.getExperimentFeatureKeyMapping().get(experiment.getId()) != null) {
            notificationType = NotificationCenter.DecisionNotificationType.FEATURE_TEST.toString();
        }
        DecisionNotification decisionNotification = DecisionNotification.newExperimentDecisionNotificationBuilder().withUserId(userId).withAttributes(copiedAttributes).withExperimentKey(experiment.getKey()).withVariation(variation).withType(notificationType).build();
        this.notificationCenter.send(decisionNotification);
        return variation;
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId) throws UnknownExperimentException {
        return this.getVariation(experimentKey, userId, Collections.emptyMap());
    }

    @Nullable
    public Variation getVariation(@Nonnull String experimentKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        if (!this.validateUserId(userId)) {
            return null;
        }
        if (experimentKey == null || experimentKey.trim().isEmpty()) {
            logger.error("The experimentKey parameter must be nonnull.");
            return null;
        }
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return null;
        }
        Experiment experiment = projectConfig.getExperimentForKey(experimentKey, this.errorHandler);
        if (experiment == null) {
            return null;
        }
        return this.getVariation(projectConfig, experiment, userId, attributes);
    }

    public boolean setForcedVariation(@Nonnull String experimentKey, @Nonnull String userId, @Nullable String variationKey) {
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing isFeatureEnabled call.");
            return false;
        }
        Experiment experiment = projectConfig.getExperimentKeyMapping().get(experimentKey);
        if (experiment == null) {
            logger.error("Experiment {} does not exist in ProjectConfig for project {}", (Object)experimentKey, (Object)projectConfig.getProjectId());
            return false;
        }
        return this.decisionService.setForcedVariation(experiment, userId, variationKey);
    }

    @Nullable
    public Variation getForcedVariation(@Nonnull String experimentKey, @Nonnull String userId) {
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing getForcedVariation call.");
            return null;
        }
        Experiment experiment = projectConfig.getExperimentKeyMapping().get(experimentKey);
        if (experiment == null) {
            logger.debug("No experiment \"{}\" mapped to user \"{}\" in the forced variation map ", (Object)experimentKey, (Object)userId);
            return null;
        }
        return this.decisionService.getForcedVariation(experiment, userId);
    }

    @Nullable
    public ProjectConfig getProjectConfig() {
        return this.projectConfigManager.getConfig();
    }

    @Nullable
    public UserProfileService getUserProfileService() {
        return this.userProfileService;
    }

    private boolean validateUserId(String userId) {
        if (userId == null) {
            logger.error("The user ID parameter must be nonnull.");
            return false;
        }
        return true;
    }

    public OptimizelyConfig getOptimizelyConfig() {
        ProjectConfig projectConfig = this.getProjectConfig();
        if (projectConfig == null) {
            logger.error("Optimizely instance is not valid, failing getOptimizelyConfig call.");
            return null;
        }
        if (this.optimizelyConfigManager != null) {
            return this.optimizelyConfigManager.getOptimizelyConfig();
        }
        logger.debug("optimizelyConfigManager is null, generating new OptimizelyConfigObject as a fallback");
        return new OptimizelyConfigService(projectConfig).getConfig();
    }

    private Map<String, ?> copyAttributes(Map<String, ?> attributes) {
        HashMap copiedAttributes = null;
        if (attributes != null) {
            copiedAttributes = new HashMap(attributes);
        }
        return copiedAttributes;
    }

    public NotificationCenter getNotificationCenter() {
        return this.notificationCenter;
    }

    public int addDecisionNotificationHandler(NotificationHandler<DecisionNotification> handler) {
        return this.addNotificationHandler(DecisionNotification.class, handler);
    }

    public int addTrackNotificationHandler(NotificationHandler<TrackNotification> handler) {
        return this.addNotificationHandler(TrackNotification.class, handler);
    }

    public int addUpdateConfigNotificationHandler(NotificationHandler<UpdateConfigNotification> handler) {
        return this.addNotificationHandler(UpdateConfigNotification.class, handler);
    }

    public int addLogEventNotificationHandler(NotificationHandler<LogEvent> handler) {
        return this.addNotificationHandler(LogEvent.class, handler);
    }

    public <T> int addNotificationHandler(Class<T> clazz, NotificationHandler<T> handler) {
        return this.notificationCenter.addNotificationHandler(clazz, handler);
    }

    @Deprecated
    public static Builder builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
        return new Builder(datafile, eventHandler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String datafile;
        private Bucketer bucketer;
        private DecisionService decisionService;
        private ErrorHandler errorHandler;
        private EventHandler eventHandler;
        private EventProcessor eventProcessor;
        private ProjectConfig projectConfig;
        private ProjectConfigManager projectConfigManager;
        private OptimizelyConfigManager optimizelyConfigManager;
        private UserProfileService userProfileService;
        private NotificationCenter notificationCenter;
        private AtomicProjectConfigManager fallbackConfigManager = new AtomicProjectConfigManager();

        @Deprecated
        public Builder(@Nonnull String datafile, @Nonnull EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            this.datafile = datafile;
        }

        public Builder() {
        }

        public Builder withErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        @Deprecated
        public Builder withEventHandler(EventHandler eventHandler) {
            this.eventHandler = eventHandler;
            return this;
        }

        public Builder withEventProcessor(EventProcessor eventProcessor) {
            this.eventProcessor = eventProcessor;
            return this;
        }

        public Builder withUserProfileService(UserProfileService userProfileService) {
            this.userProfileService = userProfileService;
            return this;
        }

        @Deprecated
        public Builder withClientEngine(EventBatch.ClientEngine clientEngine) {
            logger.info("Deprecated. In the future, set ClientEngine via ClientEngineInfo#setClientEngine.");
            ClientEngineInfo.setClientEngine(clientEngine);
            return this;
        }

        @Deprecated
        public Builder withClientVersion(String clientVersion) {
            logger.info("Explicitly setting the ClientVersion is no longer supported.");
            return this;
        }

        public Builder withConfigManager(ProjectConfigManager projectConfigManager) {
            this.projectConfigManager = projectConfigManager;
            return this;
        }

        public Builder withNotificationCenter(NotificationCenter notificationCenter) {
            this.notificationCenter = notificationCenter;
            return this;
        }

        public Builder withDatafile(String datafile) {
            this.datafile = datafile;
            return this;
        }

        protected Builder withBucketing(Bucketer bucketer) {
            this.bucketer = bucketer;
            return this;
        }

        protected Builder withConfig(ProjectConfig projectConfig) {
            this.projectConfig = projectConfig;
            return this;
        }

        protected Builder withDecisionService(DecisionService decisionService) {
            this.decisionService = decisionService;
            return this;
        }

        public Optimizely build() {
            if (this.errorHandler == null) {
                this.errorHandler = new NoOpErrorHandler();
            }
            if (this.eventHandler == null) {
                this.eventHandler = new NoopEventHandler();
            }
            if (this.bucketer == null) {
                this.bucketer = new Bucketer();
            }
            if (this.decisionService == null) {
                this.decisionService = new DecisionService(this.bucketer, this.errorHandler, this.userProfileService);
            }
            if (this.projectConfig == null && this.datafile != null && !this.datafile.isEmpty()) {
                try {
                    this.projectConfig = new DatafileProjectConfig.Builder().withDatafile(this.datafile).build();
                    logger.info("Datafile successfully loaded with revision: {}", (Object)this.projectConfig.getRevision());
                }
                catch (ConfigParseException ex) {
                    logger.error("Unable to parse the datafile", (Throwable)ex);
                    logger.info("Datafile is invalid");
                    this.errorHandler.handleError(new OptimizelyRuntimeException(ex));
                }
            }
            if (this.projectConfig != null) {
                this.fallbackConfigManager.setConfig(this.projectConfig);
            }
            if (this.projectConfigManager == null) {
                this.projectConfigManager = this.fallbackConfigManager;
            }
            if (this.projectConfigManager instanceof OptimizelyConfigManager) {
                this.optimizelyConfigManager = (OptimizelyConfigManager)((Object)this.projectConfigManager);
            }
            if (this.notificationCenter == null) {
                this.notificationCenter = new NotificationCenter();
            }
            if (this.eventProcessor == null) {
                this.eventProcessor = new ForwardingEventProcessor(this.eventHandler, this.notificationCenter);
            }
            return new Optimizely(this.eventHandler, this.eventProcessor, this.errorHandler, this.decisionService, this.userProfileService, this.projectConfigManager, this.optimizelyConfigManager, this.notificationCenter);
        }
    }
}

