/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.notification;

import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.Variation;
import com.optimizely.ab.event.LogEvent;
import com.optimizely.ab.notification.ActivateNotificationListener;
import com.optimizely.ab.notification.ActivateNotificationListenerInterface;
import com.optimizely.ab.notification.NotificationListener;
import com.optimizely.ab.notification.TrackNotificationListener;
import com.optimizely.ab.notification.TrackNotificationListenerInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCenter {
    private int notificationListenerID = 1;
    private static final Logger logger = LoggerFactory.getLogger(NotificationCenter.class);
    private Map<NotificationType, ArrayList<NotificationHolder>> notificationsListeners = new HashMap<NotificationType, ArrayList<NotificationHolder>>();

    public NotificationCenter() {
        this.notificationsListeners.put(NotificationType.Activate, new ArrayList());
        this.notificationsListeners.put(NotificationType.Track, new ArrayList());
    }

    public int addActivateNotificationListener(final ActivateNotificationListenerInterface activateNotificationListenerInterface) {
        if (activateNotificationListenerInterface instanceof ActivateNotificationListener) {
            return this.addNotificationListener(NotificationType.Activate, (NotificationListener)((Object)activateNotificationListenerInterface));
        }
        return this.addNotificationListener(NotificationType.Activate, new ActivateNotificationListener(){

            @Override
            public void onActivate(@Nonnull Experiment experiment, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull Variation variation, @Nonnull LogEvent event) {
                activateNotificationListenerInterface.onActivate(experiment, userId, attributes, variation, event);
            }
        });
    }

    public int addTrackNotificationListener(final TrackNotificationListenerInterface trackNotificationListenerInterface) {
        if (trackNotificationListenerInterface instanceof TrackNotificationListener) {
            return this.addNotificationListener(NotificationType.Activate, (NotificationListener)((Object)trackNotificationListenerInterface));
        }
        return this.addNotificationListener(NotificationType.Track, new TrackNotificationListener(){

            @Override
            public void onTrack(@Nonnull String eventKey, @Nonnull String userId, @Nonnull Map<String, ?> attributes, @Nonnull Map<String, ?> eventTags, @Nonnull LogEvent event) {
                trackNotificationListenerInterface.onTrack(eventKey, userId, attributes, eventTags, event);
            }
        });
    }

    public int addNotificationListener(NotificationType notificationType, NotificationListener notificationListener) {
        Class clazz = notificationType.notificationTypeClass;
        if (clazz == null || !clazz.isInstance(notificationListener)) {
            logger.warn("Notification listener was the wrong type. It was not added to the notification center.");
            return -1;
        }
        for (NotificationHolder holder : this.notificationsListeners.get((Object)notificationType)) {
            if (holder.notificationListener != notificationListener) continue;
            logger.warn("Notificication listener was already added");
            return -1;
        }
        int id = this.notificationListenerID++;
        this.notificationsListeners.get((Object)notificationType).add(new NotificationHolder(id, notificationListener));
        logger.info("Notification listener {} was added with id {}", (Object)notificationListener.toString(), (Object)id);
        return id;
    }

    public boolean removeNotificationListener(int notificationID) {
        for (NotificationType type : NotificationType.values()) {
            for (NotificationHolder holder : this.notificationsListeners.get((Object)type)) {
                if (holder.notificationId != notificationID) continue;
                this.notificationsListeners.get((Object)type).remove(holder);
                logger.info("Notification listener removed {}", (Object)notificationID);
                return true;
            }
        }
        logger.warn("Notification listener with id {} not found", (Object)notificationID);
        return false;
    }

    public void clearAllNotificationListeners() {
        for (NotificationType type : NotificationType.values()) {
            this.clearNotificationListeners(type);
        }
    }

    public void clearNotificationListeners(NotificationType notificationType) {
        this.notificationsListeners.get((Object)notificationType).clear();
    }

    public void sendNotifications(NotificationType notificationType, Object ... args) {
        ArrayList<NotificationHolder> holders = this.notificationsListeners.get((Object)notificationType);
        for (NotificationHolder holder : holders) {
            try {
                holder.notificationListener.notify(args);
            }
            catch (Exception e) {
                logger.error("Unexpected exception calling notification listener {}", (Object)holder.notificationId, (Object)e);
            }
        }
    }

    private static class NotificationHolder {
        int notificationId;
        NotificationListener notificationListener;

        NotificationHolder(int id, NotificationListener notificationListener) {
            this.notificationId = id;
            this.notificationListener = notificationListener;
        }
    }

    public static enum NotificationType {
        Activate(ActivateNotificationListener.class),
        Track(TrackNotificationListener.class);

        private Class notificationTypeClass;

        private NotificationType(Class notificationClass) {
            this.notificationTypeClass = notificationClass;
        }

        public Class getNotificationTypeClass() {
            return this.notificationTypeClass;
        }
    }
}

