/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.internal;

import com.optimizely.ab.config.Experiment;
import com.optimizely.ab.config.ProjectConfig;
import com.optimizely.ab.config.audience.AudienceIdCondition;
import com.optimizely.ab.config.audience.Condition;
import com.optimizely.ab.config.audience.OrCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExperimentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentUtils.class);

    private ExperimentUtils() {
    }

    public static boolean isExperimentActive(@Nonnull Experiment experiment) {
        if (!experiment.isActive()) {
            logger.info("Experiment \"{}\" is not running.", (Object)experiment.getKey());
            return false;
        }
        return true;
    }

    public static boolean isUserInExperiment(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull Map<String, ?> attributes) {
        if (experiment.getAudienceConditions() != null) {
            Boolean resolveReturn = ExperimentUtils.evaluateAudienceConditions(projectConfig, experiment, attributes);
            return resolveReturn == null ? false : resolveReturn;
        }
        Boolean resolveReturn = ExperimentUtils.evaluateAudience(projectConfig, experiment, attributes);
        return Boolean.TRUE.equals(resolveReturn);
    }

    @Nullable
    public static Boolean evaluateAudience(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull Map<String, ?> attributes) {
        List<String> experimentAudienceIds = experiment.getAudienceIds();
        if (experimentAudienceIds.isEmpty()) {
            logger.debug("There is no Audience associated with experiment {}", (Object)experiment.getKey());
            return true;
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String audienceId : experimentAudienceIds) {
            AudienceIdCondition condition = new AudienceIdCondition(audienceId);
            conditions.add(condition);
        }
        OrCondition implicitOr = new OrCondition(conditions);
        logger.debug("Evaluating audiences for experiment \"{}\": \"{}\"", (Object)experiment.getKey(), conditions);
        Boolean result = implicitOr.evaluate(projectConfig, attributes);
        logger.info("Audiences for experiment {} collectively evaluated to {}", (Object)experiment.getKey(), (Object)result);
        return result;
    }

    @Nullable
    public static Boolean evaluateAudienceConditions(@Nonnull ProjectConfig projectConfig, @Nonnull Experiment experiment, @Nonnull Map<String, ?> attributes) {
        Condition conditions = experiment.getAudienceConditions();
        if (conditions == null) {
            return null;
        }
        logger.debug("Evaluating audiences for experiment \"{}\": \"{}\"", (Object)experiment.getKey(), (Object)conditions.toString());
        try {
            Boolean result = conditions.evaluate(projectConfig, attributes);
            logger.info("Audiences for experiment {} collectively evaluated to {}", (Object)experiment.getKey(), (Object)result);
            return result;
        }
        catch (Exception e) {
            logger.error("Condition invalid", (Throwable)e);
            return null;
        }
    }
}

