/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.event.internal.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.optimizely.ab.event.internal.serializer.SerializationException;
import com.optimizely.ab.event.internal.serializer.Serializer;

class JacksonSerializer
implements Serializer {
    private final ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);

    JacksonSerializer() {
    }

    @Override
    public <T> String serialize(T payload) {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return this.mapper.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Unable to serialize payload", e);
        }
    }
}

